/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.regex.RegExCache;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.period.ILocalDatePeriod;
import com.helger.datetime.period.LocalDatePeriod;
import com.helger.masterdata.swift.EIBANElementType;
import com.helger.masterdata.swift.IBANElement;
import com.helger.masterdata.swift.IBANElementValue;
import com.helger.masterdata.swift.IBANManager;
import java.time.LocalDate;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IBANCountryData
implements ILocalDatePeriod {
    private final int m_nExpectedLength;
    private final Pattern m_aPattern;
    private final ICommonsList<IBANElement> m_aElements;
    private final String m_sFixedCheckDigits;
    private final LocalDatePeriod m_aValidity;

    public IBANCountryData(@Nonnegative int n, @Nullable Pattern pattern, @Nullable String string, @Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nonnull List<IBANElement> list) {
        ValueEnforcer.notNull(list, "Elements");
        if (string != null) {
            ValueEnforcer.isTrue(string.length() == 2, "Check digits must be length 2!");
            ValueEnforcer.isTrue(StringParser.isUnsignedInt(string), "Check digits must be all numeric!");
        }
        this.m_nExpectedLength = n;
        this.m_aPattern = pattern;
        this.m_aElements = new CommonsArrayList<List<IBANElement>>(list);
        this.m_sFixedCheckDigits = string;
        this.m_aValidity = new LocalDatePeriod(localDate, localDate2);
        int n2 = 0;
        for (IBANElement iBANElement : list) {
            n2 += iBANElement.getLength();
        }
        if (n2 != n) {
            throw new IllegalArgumentException("Expected length=" + n + "; calced length=" + n2);
        }
    }

    @Nonnegative
    public int getExpectedLength() {
        return this.m_nExpectedLength;
    }

    public boolean hasPattern() {
        return this.m_aPattern != null;
    }

    @Nullable
    public Pattern getPattern() {
        return this.m_aPattern;
    }

    public boolean matchesPattern(@Nonnull String string) {
        if (this.m_aPattern == null) {
            return true;
        }
        return this.m_aPattern.matcher(string).matches();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IBANElement> getAllElements() {
        return (ICommonsList)this.m_aElements.getClone();
    }

    public boolean hasFixedCheckDigits() {
        return this.m_sFixedCheckDigits != null;
    }

    @Nullable
    public String getFixedCheckDigits() {
        return this.m_sFixedCheckDigits;
    }

    @Override
    @Nullable
    public LocalDate getStart() {
        return this.m_aValidity.getStart();
    }

    @Override
    @Nullable
    public LocalDate getEnd() {
        return this.m_aValidity.getEnd();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IBANElementValue> parseToElementValues(@Nonnull String string) {
        ValueEnforcer.notNull(string, "IBANString");
        String string2 = IBANManager.unifyIBAN(string);
        if (string2.length() != this.m_nExpectedLength) {
            throw new IllegalArgumentException("Passed IBAN has an invalid length. Expected " + this.m_nExpectedLength + " but found " + string2.length());
        }
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(this.m_aElements.size());
        int n = 0;
        for (IBANElement iBANElement : this.m_aElements) {
            String string3 = string2.substring(n, n + iBANElement.getLength());
            commonsArrayList.add(new IBANElementValue(iBANElement, string3));
            n += iBANElement.getLength();
        }
        return commonsArrayList;
    }

    public String toString() {
        return new ToStringGenerator(this).append("elements", this.m_aElements).append("expectedLength", this.m_nExpectedLength).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<IBANElement> _parseElements(@Nonnull String string) {
        CommonsArrayList<IBANElement> commonsArrayList = new CommonsArrayList<IBANElement>();
        commonsArrayList.add(new IBANElement(EIBANElementType.COUNTRY_CODE, 2));
        EIBANElementType eIBANElementType = null;
        int n = 0;
        int n2 = string.length();
        for (int i = 2; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            EIBANElementType eIBANElementType2 = EIBANElementType.getElementTypeFromChar(c);
            if (eIBANElementType2 == null) {
                throw new IllegalArgumentException("Illegal char '" + c + "' in description '" + string + "'");
            }
            if (eIBANElementType == null || eIBANElementType == eIBANElementType2) {
                eIBANElementType = eIBANElementType2;
                ++n;
                continue;
            }
            commonsArrayList.add(new IBANElement(eIBANElementType, n));
            eIBANElementType = eIBANElementType2;
            n = 1;
        }
        if (n > 0) {
            commonsArrayList.add(new IBANElement(eIBANElementType, n));
        }
        return commonsArrayList;
    }

    @Nullable
    private static Pattern _parseLayout(@Nonnull @Nonempty String string, @Nonnegative int n, @Nullable String string2, @Nullable String string3) {
        if (string3 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(Pattern.quote(string + string2));
        } else {
            stringBuilder.append(Pattern.quote(string));
            stringBuilder.append("[0-9]{2}");
        }
        int n2 = 4;
        for (String string4 : StringHelper.getExploded(',', string3)) {
            String[] stringArray = RegExHelper.getAllMatchingGroupValues("([0-9]+)([anc])", string4);
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Failed to parse layout part '" + string4 + "'");
            }
            int n3 = StringParser.parseInt(stringArray[0], -1);
            if (n3 <= 0) {
                throw new IllegalArgumentException("Failed to parse layout part '" + string4 + "' - illegal numeric value");
            }
            n2 += n3;
            if (stringArray[1].length() != 1) {
                throw new IllegalArgumentException("Failed to parse layout part '" + string4 + "' - type length is invalid");
            }
            char c = stringArray[1].charAt(0);
            if (c == 'a') {
                stringBuilder.append("[A-Z]{" + n3 + "}");
                continue;
            }
            if (c == 'n') {
                stringBuilder.append("[0-9]{" + n3 + "}");
                continue;
            }
            if (c == 'c') {
                stringBuilder.append("[a-zA-Z0-9]{" + n3 + "}");
                continue;
            }
            throw new IllegalArgumentException("Failed to parse layout part '" + string4 + "' - type is invalid");
        }
        if (n2 != n) {
            throw new IllegalArgumentException("Failed to parse layout - length mismatch. Having " + n2 + " but expected " + n);
        }
        return RegExCache.getPattern(stringBuilder.toString());
    }

    @Nonnull
    public static IBANCountryData createFromString(@Nonnull @Nonempty String string, @Nonnegative int n, @Nullable String string2, @Nullable String string3, @Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nonnull String string4) {
        ValueEnforcer.notEmpty(string4, "Desc");
        if (string4.length() < 4) {
            throw new IllegalArgumentException("Cannot converted passed string because it is too short!");
        }
        ICommonsList<IBANElement> iCommonsList = IBANCountryData._parseElements(string4);
        Pattern pattern = IBANCountryData._parseLayout(string, n, string3, string2);
        try {
            return new IBANCountryData(n, pattern, string3, localDate, localDate2, iCommonsList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to parse '" + string4 + "': " + illegalArgumentException.getMessage());
        }
    }
}

