/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.swift.EIBANElementType;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IBANElement
implements Serializable {
    private final EIBANElementType m_eElementType;
    private final int m_nLength;

    public IBANElement(@Nonnull EIBANElementType eIBANElementType, @Nonnegative int n) {
        this.m_eElementType = ValueEnforcer.notNull(eIBANElementType, "ElementType");
        this.m_nLength = ValueEnforcer.isGT0(n, "Length");
    }

    @Nonnull
    public EIBANElementType getElementType() {
        return this.m_eElementType;
    }

    @Nonnegative
    public int getLength() {
        return this.m_nLength;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IBANElement iBANElement = (IBANElement)object;
        return this.m_eElementType.equals((Object)iBANElement.m_eElementType) && this.m_nLength == iBANElement.m_nLength;
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eElementType)).append(this.m_nLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("elementType", this.m_eElementType).append("length", this.m_nLength).getToString();
    }
}

