/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.util.XMLMapHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DialCodeManager {
    private static final ICommonsMap<String, String> s_aCountryToDialCode = new CommonsHashMap<String, String>();

    private DialCodeManager() {
    }

    @Nullable
    public static String getDialCodeOfCountry(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return (String)s_aCountryToDialCode.get(string.toUpperCase(Locale.US));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAllDialCodes() {
        return (ICommonsMap)s_aCountryToDialCode.getClone();
    }

    static {
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/dialcode-country-data.xml"), s_aCountryToDialCode).isFailure()) {
            throw new InitializationException("Failed to init dial code country data");
        }
    }
}

