/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.telephone.ITelephoneNumber;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TelephoneHelper {
    private TelephoneHelper() {
    }

    @Nullable
    @CheckReturnValue
    public static String getTelephoneString(@Nullable ITelephoneNumber iTelephoneNumber) {
        if (iTelephoneNumber == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(iTelephoneNumber.getCountryCode()) && StringHelper.hasText(iTelephoneNumber.getAreaCode())) {
            if (!StringHelper.startsWith((CharSequence)iTelephoneNumber.getCountryCode(), '+')) {
                stringBuilder.append('+');
            }
            stringBuilder.append(iTelephoneNumber.getCountryCode()).append('/');
            if (StringHelper.startsWith((CharSequence)iTelephoneNumber.getAreaCode(), '0')) {
                stringBuilder.append(iTelephoneNumber.getAreaCode().substring(1));
            } else {
                stringBuilder.append(iTelephoneNumber.getAreaCode());
            }
        } else if (iTelephoneNumber.getAreaCode() != null) {
            stringBuilder.append(iTelephoneNumber.getAreaCode());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('/');
        }
        if (iTelephoneNumber.getLine() != null) {
            stringBuilder.append(iTelephoneNumber.getLine());
        }
        if (StringHelper.hasText(iTelephoneNumber.getDirectDial())) {
            stringBuilder.append('-').append(iTelephoneNumber.getDirectDial());
        }
        return stringBuilder.toString();
    }

    @Nullable
    @CheckReturnValue
    public static String getCleanedLine(@Nullable String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasText(string2)) {
            string2 = RegExHelper.stringReplacePattern("begin_of_the_skype_highlighting.+end_of_the_skype_highlighting", string2, "");
        }
        return string2;
    }
}

