/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.unit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.id.IHasIntID;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.masterdata.unit.EISO31;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnitSector
implements IHasIntID,
IHasDisplayText {
    private final int m_nGroupNumber;
    private final IMultilingualText m_aName;
    private final EISO31 m_eISO31;

    public UnitSector(@Nonnegative int n, @Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.isGE0(n, "GroupNumber");
        ValueEnforcer.notNull(iMultilingualText, "Name");
        this.m_nGroupNumber = n;
        this.m_aName = iMultilingualText;
        this.m_eISO31 = EISO31.getFromIDOrNull(n);
    }

    @Override
    @Nonnegative
    public int getID() {
        return this.m_nGroupNumber;
    }

    @Nonnull
    public IMultilingualText getName() {
        return this.m_aName;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getText(locale);
    }

    @Nullable
    public EISO31 getISO31() {
        return this.m_eISO31;
    }

    public String toString() {
        return new ToStringGenerator(this).append("groupNumber", this.m_nGroupNumber).append("name", this.m_aName).append("iso31", this.m_eISO31).getToString();
    }
}

