/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.masterdata.tax.ETaxCategoryUN5305;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EVATItemType implements IHasID<String>
{
    REGULAR("regular", ETaxCategoryUN5305.S),
    INBETWEEN("inbetween", ETaxCategoryUN5305.A),
    REDUCED("reduced", ETaxCategoryUN5305.AA),
    REDUCED_HEAVILY("reduced_heavily", ETaxCategoryUN5305.AA),
    OTHER("other", null);

    private final String m_sID;
    private final ETaxCategoryUN5305 m_eTaxCategory;

    private EVATItemType(String string2, ETaxCategoryUN5305 eTaxCategoryUN5305) {
        this.m_sID = string2;
        this.m_eTaxCategory = eTaxCategoryUN5305;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public ETaxCategoryUN5305 getTaxCategory() {
        return this.m_eTaxCategory;
    }

    @Nullable
    public static EVATItemType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EVATItemType.class, string);
    }
}

