/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.functional.IToBooleanFunction;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.iso.ISO7064;
import java.util.Locale;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;

public class VATINSyntaxChecker {
    private static final ICommonsMap<String, IToBooleanFunction<String>> s_aMap = new CommonsHashMap<String, IToBooleanFunction<String>>();
    private static final char[] ES_V2;
    private static final int[] CY_ODD;
    private static final int[] CZ_V3;
    private static final int CZ_YEAR_MAX;

    private VATINSyntaxChecker() {
    }

    public static boolean isValidVATIN(@Nonnull String string) {
        return VATINSyntaxChecker.isValidVATIN(string, true);
    }

    public static boolean isValidVATIN(@Nonnull String string, boolean bl) {
        String string2;
        IToBooleanFunction iToBooleanFunction;
        ValueEnforcer.notNull(string, "VATIN");
        if (string.length() > 2 && (iToBooleanFunction = (IToBooleanFunction)s_aMap.get(string2 = string.substring(0, 2).toUpperCase(Locale.US))) != null) {
            return iToBooleanFunction.applyAsBoolean(string.substring(2));
        }
        return bl;
    }

    public static boolean isValidatorPresent(@Nonnull String string) {
        ValueEnforcer.notNull(string, "VATIN");
        if (string.length() <= 2) {
            return false;
        }
        String string2 = string.substring(0, 2).toUpperCase(Locale.US);
        return s_aMap.containsKey(string2);
    }

    static int ceilTo(int n, int n2) {
        int n3 = n % n2;
        return n + (n3 == 0 ? 0 : (n2 - n3) % n2);
    }

    private static boolean _isNum(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean _isNum1to9(char c) {
        return c >= '1' && c <= '9';
    }

    private static boolean _isLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean _isLetterOrNum(char c) {
        return VATINSyntaxChecker._isLetter(c) || VATINSyntaxChecker._isNum(c);
    }

    private static int _toInt(char c) {
        return c - 48;
    }

    private static int _toInt(char c, char c2) {
        return VATINSyntaxChecker._toInt(c) * 10 + VATINSyntaxChecker._toInt(c2);
    }

    private static int _toInt(char c, char c2, char c3) {
        return VATINSyntaxChecker._toInt(c) * 100 + VATINSyntaxChecker._toInt(c2) * 10 + VATINSyntaxChecker._toInt(c3);
    }

    private static int _toInt(char c, char c2, char c3, char c4, char c5, char c6) {
        return VATINSyntaxChecker._toInt(c) * 100000 + VATINSyntaxChecker._toInt(c2) * 10000 + VATINSyntaxChecker._toInt(c3) * 1000 + VATINSyntaxChecker._toInt(c4) * 100 + VATINSyntaxChecker._toInt(c5) * 10 + VATINSyntaxChecker._toInt(c6);
    }

    private static int _toInt(char c, char c2, char c3, char c4, char c5, char c6, char c7) {
        return VATINSyntaxChecker._toInt(c) * 1000000 + VATINSyntaxChecker._toInt(c2) * 100000 + VATINSyntaxChecker._toInt(c3) * 10000 + VATINSyntaxChecker._toInt(c4) * 1000 + VATINSyntaxChecker._toInt(c5) * 100 + VATINSyntaxChecker._toInt(c6) * 10 + VATINSyntaxChecker._toInt(c7);
    }

    private static int _toInt(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8) {
        return VATINSyntaxChecker._toInt(c) * 10000000 + VATINSyntaxChecker._toInt(c2) * 1000000 + VATINSyntaxChecker._toInt(c3) * 100000 + VATINSyntaxChecker._toInt(c4) * 10000 + VATINSyntaxChecker._toInt(c5) * 1000 + VATINSyntaxChecker._toInt(c6) * 100 + VATINSyntaxChecker._toInt(c7) * 10 + VATINSyntaxChecker._toInt(c8);
    }

    private static int _toInt(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) {
        return VATINSyntaxChecker._toInt(c) * 100000000 + VATINSyntaxChecker._toInt(c2) * 10000000 + VATINSyntaxChecker._toInt(c3) * 1000000 + VATINSyntaxChecker._toInt(c4) * 100000 + VATINSyntaxChecker._toInt(c5) * 10000 + VATINSyntaxChecker._toInt(c6) * 1000 + VATINSyntaxChecker._toInt(c7) * 100 + VATINSyntaxChecker._toInt(c8) * 10 + VATINSyntaxChecker._toInt(c9);
    }

    private static long _toLong(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9, char c10) {
        return (long)VATINSyntaxChecker._toInt(c) * 1000000000L + (long)VATINSyntaxChecker._toInt(c2) * 100000000L + (long)VATINSyntaxChecker._toInt(c3) * 10000000L + (long)VATINSyntaxChecker._toInt(c4) * 1000000L + (long)VATINSyntaxChecker._toInt(c5) * 100000L + (long)VATINSyntaxChecker._toInt(c6) * 10000L + (long)VATINSyntaxChecker._toInt(c7) * 1000L + (long)VATINSyntaxChecker._toInt(c8) * 100L + (long)VATINSyntaxChecker._toInt(c9) * 10L + (long)VATINSyntaxChecker._toInt(c10);
    }

    private static long _toLong(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9, char c10, char c11) {
        return (long)VATINSyntaxChecker._toInt(c) * 10000000000L + (long)VATINSyntaxChecker._toInt(c2) * 1000000000L + (long)VATINSyntaxChecker._toInt(c3) * 100000000L + (long)VATINSyntaxChecker._toInt(c4) * 10000000L + (long)VATINSyntaxChecker._toInt(c5) * 1000000L + (long)VATINSyntaxChecker._toInt(c6) * 100000L + (long)VATINSyntaxChecker._toInt(c7) * 10000L + (long)VATINSyntaxChecker._toInt(c8) * 1000L + (long)VATINSyntaxChecker._toInt(c9) * 100L + (long)VATINSyntaxChecker._toInt(c10) * 10L + (long)VATINSyntaxChecker._toInt(c11);
    }

    private static boolean _isValidMonthDay(int n, int n2) {
        if (n == 2) {
            return n2 >= 1 && n2 <= 29;
        }
        if (n == 4 || n == 6 || n == 9 || n == 11) {
            return n2 >= 1 && n2 <= 30;
        }
        if (n == 1 || n == 3 || n == 5 || n == 7 || n == 8 || n == 10 || n == 12) {
            return n2 >= 1 && n2 <= 31;
        }
        return false;
    }

    private static int _at_s(char c) {
        int n = VATINSyntaxChecker._toInt(c);
        return n / 5 + n * 2 % 10;
    }

    public static boolean isValidVATIN_AT(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        if (cArray[0] != 'U') {
            return false;
        }
        for (n = 1; n <= 8; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = VATINSyntaxChecker._at_s(cArray[2]) + VATINSyntaxChecker._at_s(cArray[4]) + VATINSyntaxChecker._at_s(cArray[6]);
        int n2 = (10 - (n + VATINSyntaxChecker._toInt(cArray[1]) + VATINSyntaxChecker._toInt(cArray[3]) + VATINSyntaxChecker._toInt(cArray[5]) + VATINSyntaxChecker._toInt(cArray[7]) + 4) % 10) % 10;
        return VATINSyntaxChecker._toInt(cArray[8]) == n2;
    }

    public static boolean isValidVATIN_BE(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 10) {
            return false;
        }
        if (cArray[0] != '0') {
            return false;
        }
        if (!VATINSyntaxChecker._isNum1to9(cArray[1])) {
            return false;
        }
        for (n = 2; n <= 9; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 97 - VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7]) % 97;
        int n2 = VATINSyntaxChecker._toInt(cArray[8], cArray[9]);
        return n2 == n;
    }

    public static boolean isValidVATIN_DE(@Nonnull String string) {
        int n;
        int n2;
        int n3;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum1to9(cArray[0])) {
            return false;
        }
        for (n3 = 1; n3 <= 8; ++n3) {
            if (VATINSyntaxChecker._isNum(cArray[n3])) continue;
            return false;
        }
        n3 = 10;
        for (n2 = 0; n2 <= 7; ++n2) {
            n = (VATINSyntaxChecker._toInt(cArray[n2]) + n3) % 10;
            if (n == 0) {
                n = 10;
            }
            n3 = 2 * n % 11;
        }
        n2 = 11 - n3;
        n = n2 == 10 ? 0 : n2;
        int n4 = VATINSyntaxChecker._toInt(cArray[8]);
        return n == n4;
    }

    public static boolean isValidVATIN_DK(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum1to9(cArray[0])) {
            return false;
        }
        for (n = 1; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 2 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 6 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 4 * VATINSyntaxChecker._toInt(cArray[4]) + 3 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6]) + 1 * VATINSyntaxChecker._toInt(cArray[7]);
        return n % 11 == 0;
    }

    public static boolean isValidVATIN_EL(@Nonnull String string) {
        int n;
        int n2;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        for (n2 = 0; n2 <= 8; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = 256 * VATINSyntaxChecker._toInt(cArray[0]) + 128 * VATINSyntaxChecker._toInt(cArray[1]) + 64 * VATINSyntaxChecker._toInt(cArray[2]) + 32 * VATINSyntaxChecker._toInt(cArray[3]) + 16 * VATINSyntaxChecker._toInt(cArray[4]) + 8 * VATINSyntaxChecker._toInt(cArray[5]) + 4 * VATINSyntaxChecker._toInt(cArray[6]) + 2 * VATINSyntaxChecker._toInt(cArray[7]);
        int n3 = n2 % 11;
        int n4 = n3 % 10;
        return n4 == (n = VATINSyntaxChecker._toInt(cArray[8]));
    }

    private static boolean _es_c1valid_c9alpha(char c) {
        return c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'G' || c == 'H' || c == 'K' || c == 'L' || c == 'M' || c == 'N' || c == 'P' || c == 'Q' || c == 'R' || c == 'S' || c == 'W' || c == 'X' || c == 'Y' || c == 'Z' || VATINSyntaxChecker._isNum(c);
    }

    private static boolean _es_c1valid_c9num(char c) {
        return c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'G' || c == 'H' || c == 'J' || c == 'U' || c == 'V';
    }

    private static boolean _es_isV1(char c) {
        return c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'G' || c == 'H' || c == 'N' || c == 'P' || c == 'Q' || c == 'R' || c == 'S' || c == 'W';
    }

    private static boolean _es_isV2(char c) {
        return c == 'K' || c == 'L' || c == 'M' || c == 'X' || c == 'Y' || c == 'Z' || VATINSyntaxChecker._isNum(c);
    }

    private static int _es_d(char c) {
        int n = VATINSyntaxChecker._toInt(c);
        return n / 5 + 2 * n % 10;
    }

    public static boolean isValidVATIN_ES(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        if (!VATINSyntaxChecker._isLetterOrNum(cArray[0])) {
            return false;
        }
        for (n = 1; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (!VATINSyntaxChecker._isLetterOrNum(cArray[8])) {
            return false;
        }
        n = VATINSyntaxChecker._isLetter(cArray[8]) ? 1 : 0;
        if (n != 0) {
            if (!VATINSyntaxChecker._es_c1valid_c9alpha(cArray[0])) {
                return false;
            }
            if (VATINSyntaxChecker._es_isV1(cArray[0])) {
                int n2;
                int n3 = VATINSyntaxChecker._toInt(cArray[2]) + VATINSyntaxChecker._toInt(cArray[4]) + VATINSyntaxChecker._toInt(cArray[6]);
                int n4 = 10 - (n3 + (n2 = VATINSyntaxChecker._es_d(cArray[1]) + VATINSyntaxChecker._es_d(cArray[3]) + VATINSyntaxChecker._es_d(cArray[5]) + VATINSyntaxChecker._es_d(cArray[7]))) % 10;
                return cArray[8] == 65 + n4 - 1;
            }
            if (VATINSyntaxChecker._es_isV2(cArray[0])) {
                char c = cArray[0] == 'Y' ? (char)'1' : (cArray[0] == 'Z' ? (char)'2' : cArray[0]);
                int n5 = VATINSyntaxChecker._isNum(c) ? VATINSyntaxChecker._toInt(c, cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7]) % 23 + 1 : VATINSyntaxChecker._toInt(cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7]) % 23 + 1;
                return cArray[8] == ES_V2[n5 - 1];
            }
        } else {
            int n6;
            int n7;
            if (!VATINSyntaxChecker._es_c1valid_c9num(cArray[0])) {
                return false;
            }
            int n8 = VATINSyntaxChecker._toInt(cArray[2]) + VATINSyntaxChecker._toInt(cArray[4]) + VATINSyntaxChecker._toInt(cArray[6]);
            int n9 = 10 - (n8 + (n7 = VATINSyntaxChecker._es_d(cArray[1]) + VATINSyntaxChecker._es_d(cArray[3]) + VATINSyntaxChecker._es_d(cArray[5]) + VATINSyntaxChecker._es_d(cArray[7]))) % 10;
            int n10 = n9 % 10;
            return n10 == (n6 = VATINSyntaxChecker._toInt(cArray[8]));
        }
        return false;
    }

    public static boolean isValidVATIN_FI(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 11 - (7 * VATINSyntaxChecker._toInt(cArray[0]) + 9 * VATINSyntaxChecker._toInt(cArray[1]) + 10 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 8 * VATINSyntaxChecker._toInt(cArray[4]) + 4 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6])) % 11;
        if (n == 10) {
            return false;
        }
        int n2 = n == 11 ? 0 : n;
        int n3 = VATINSyntaxChecker._toInt(cArray[7]);
        return n2 == n3;
    }

    @CheckForSigned
    private static int _fr_check(char c) {
        if (VATINSyntaxChecker._isNum(c)) {
            return VATINSyntaxChecker._toInt(c);
        }
        int n = "ABCDEFGHJKLMNPQRSTUVWXYZ".indexOf(c);
        if (n < 0) {
            return -1;
        }
        return 10 + n;
    }

    public static boolean isValidVATIN_FR(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 11) {
            return false;
        }
        if (!VATINSyntaxChecker._isLetterOrNum(cArray[0])) {
            return false;
        }
        if (!VATINSyntaxChecker._isLetterOrNum(cArray[1])) {
            return false;
        }
        for (n = 2; n <= 10; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = VATINSyntaxChecker._isNum(cArray[0]) ? 1 : 0;
        boolean bl = VATINSyntaxChecker._isNum(cArray[1]);
        if (n != 0 && bl) {
            int n2;
            int n3 = (int)(VATINSyntaxChecker._toLong(cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7], cArray[8], cArray[9], cArray[10], '1', '2') % 97L);
            return n3 == (n2 = VATINSyntaxChecker._toInt(cArray[0], cArray[1]));
        }
        int n4 = VATINSyntaxChecker._fr_check(cArray[0]);
        if (n4 < 0) {
            return false;
        }
        int n5 = VATINSyntaxChecker._fr_check(cArray[1]);
        if (n5 < 0) {
            return false;
        }
        int n6 = n != 0 ? n4 * 24 + (n5 - 10) : n4 * 34 + (n5 - 100);
        int n7 = n6 / 11 + 1;
        int n8 = n6 % 11;
        int n9 = (VATINSyntaxChecker._toInt(cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7], cArray[8], cArray[9], cArray[10]) + n7) % 11;
        return n8 == n9;
    }

    public static boolean isValidVATIN_GB(@Nonnull String string) {
        int n;
        int n2;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length == 5) {
            if (cArray[0] == 'G' && cArray[1] == 'D') {
                int n3 = VATINSyntaxChecker._toInt(cArray[2], cArray[3], cArray[4]);
                return n3 >= 0 && n3 <= 499;
            }
            if (cArray[0] == 'H' && cArray[1] == 'A') {
                int n4 = VATINSyntaxChecker._toInt(cArray[2], cArray[3], cArray[4]);
                return n4 >= 500 && n4 <= 999;
            }
            return false;
        }
        if (cArray.length != 9 && cArray.length != 12) {
            return false;
        }
        char[] cArray2 = cArray;
        int n5 = cArray2.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n = cArray2[n2];
            if (VATINSyntaxChecker._isNum((char)n)) continue;
            return false;
        }
        int n6 = VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6]);
        if (n6 >= 100000 && n6 <= 999999) {
            return false;
        }
        if (n6 >= 9490001 && n6 <= 9700000) {
            return false;
        }
        if (n6 >= 9990001 && n6 <= 9999999) {
            return false;
        }
        if (cArray.length == 12 && (n5 = VATINSyntaxChecker._toInt(cArray[9], cArray[10], cArray[11])) <= 0) {
            return false;
        }
        n5 = VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7], cArray[8]);
        if (n5 <= 0) {
            return false;
        }
        n2 = 8 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 6 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 4 * VATINSyntaxChecker._toInt(cArray[4]) + 3 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6]) + 1 * VATINSyntaxChecker._toInt(cArray[7], cArray[8]);
        n = n2 % 97;
        int n7 = (n2 + 55) % 97;
        return n == 0 || n7 == 0;
    }

    private static boolean _ie_is2(char c) {
        return c >= 'A' && c <= 'Z' || c == '+' || c == '*';
    }

    private static boolean _ie_is8(char c) {
        return c >= 'A' && c <= 'W';
    }

    private static boolean _ie_is9(char c) {
        return c >= 'A' && c <= 'I';
    }

    private static char _ie_checkChar(int n) {
        return n == 0 ? (char)'W' : (char)(65 + n - 1);
    }

    private static int _ie_toNum(char c) {
        return c - 65 + 1;
    }

    private static boolean _ie_isV1(@Nonnull char[] cArray) {
        int n;
        if (cArray.length != 8) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum(cArray[0])) {
            return false;
        }
        if (!VATINSyntaxChecker._ie_is2(cArray[1])) {
            return false;
        }
        for (n = 2; n <= 6; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (!VATINSyntaxChecker._ie_is8(cArray[7])) {
            return false;
        }
        n = (0 + VATINSyntaxChecker._toInt(cArray[2]) * 7 + VATINSyntaxChecker._toInt(cArray[3]) * 6 + VATINSyntaxChecker._toInt(cArray[4]) * 5 + VATINSyntaxChecker._toInt(cArray[5]) * 4 + VATINSyntaxChecker._toInt(cArray[6]) * 3 + VATINSyntaxChecker._toInt(cArray[0]) * 2) % 23;
        char c = VATINSyntaxChecker._ie_checkChar(n);
        return cArray[7] == c;
    }

    private static boolean _ie_isV2(@Nonnull char[] cArray) {
        int n;
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 6; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (!VATINSyntaxChecker._ie_is8(cArray[7])) {
            return false;
        }
        n = (VATINSyntaxChecker._toInt(cArray[0]) * 8 + VATINSyntaxChecker._toInt(cArray[1]) * 7 + VATINSyntaxChecker._toInt(cArray[2]) * 6 + VATINSyntaxChecker._toInt(cArray[3]) * 5 + VATINSyntaxChecker._toInt(cArray[4]) * 4 + VATINSyntaxChecker._toInt(cArray[5]) * 3 + VATINSyntaxChecker._toInt(cArray[6]) * 2) % 23;
        char c = VATINSyntaxChecker._ie_checkChar(n);
        return cArray[7] == c;
    }

    public static boolean isValidVATIN_IE(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (VATINSyntaxChecker._ie_isV1(cArray)) {
            return true;
        }
        if (VATINSyntaxChecker._ie_isV2(cArray)) {
            return true;
        }
        if (cArray.length != 9) {
            return false;
        }
        for (n = 0; n <= 6; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (!VATINSyntaxChecker._ie_is8(cArray[7])) {
            return false;
        }
        if (!VATINSyntaxChecker._ie_is9(cArray[8])) {
            return false;
        }
        n = (VATINSyntaxChecker._toInt(cArray[0]) * 8 + VATINSyntaxChecker._toInt(cArray[1]) * 7 + VATINSyntaxChecker._toInt(cArray[2]) * 6 + VATINSyntaxChecker._toInt(cArray[3]) * 5 + VATINSyntaxChecker._toInt(cArray[4]) * 4 + VATINSyntaxChecker._toInt(cArray[5]) * 3 + VATINSyntaxChecker._toInt(cArray[6]) * 2 + VATINSyntaxChecker._ie_toNum(cArray[8]) * 9) % 23;
        char c = VATINSyntaxChecker._ie_checkChar(n);
        return cArray[7] == c;
    }

    private static int _it_d(char c) {
        int n = VATINSyntaxChecker._toInt(c);
        return n / 5 + 2 * n % 10;
    }

    public static boolean isValidVATIN_IT(@Nonnull String string) {
        int n;
        int n2;
        int n3;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 11) {
            return false;
        }
        for (n3 = 0; n3 <= 10; ++n3) {
            if (VATINSyntaxChecker._isNum(cArray[n3])) continue;
            return false;
        }
        n3 = VATINSyntaxChecker._toInt(cArray[7], cArray[8], cArray[9]);
        if ((n3 <= 0 || n3 >= 101) && n3 != 120 && n3 != 121 && n3 != 999 && n3 != 888) {
            return false;
        }
        int n4 = VATINSyntaxChecker._toInt(cArray[0]) + VATINSyntaxChecker._toInt(cArray[2]) + VATINSyntaxChecker._toInt(cArray[4]) + VATINSyntaxChecker._toInt(cArray[6]) + VATINSyntaxChecker._toInt(cArray[8]);
        int n5 = (10 - (n4 + (n2 = VATINSyntaxChecker._it_d(cArray[1]) + VATINSyntaxChecker._it_d(cArray[3]) + VATINSyntaxChecker._it_d(cArray[5]) + VATINSyntaxChecker._it_d(cArray[7]) + VATINSyntaxChecker._it_d(cArray[9]))) % 10) % 10;
        return n5 == (n = VATINSyntaxChecker._toInt(cArray[10]));
    }

    public static boolean isValidVATIN_LU(@Nonnull String string) {
        int n;
        int n2;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        for (n2 = 0; n2 <= 7; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5]) % 89;
        return n2 == (n = VATINSyntaxChecker._toInt(cArray[6], cArray[7]));
    }

    private static boolean _isNL_BSN(char[] cArray) {
        int n = VATINSyntaxChecker._toInt(cArray[0]) * 9 + VATINSyntaxChecker._toInt(cArray[1]) * 8 + VATINSyntaxChecker._toInt(cArray[2]) * 7 + VATINSyntaxChecker._toInt(cArray[3]) * 6 + VATINSyntaxChecker._toInt(cArray[4]) * 5 + VATINSyntaxChecker._toInt(cArray[5]) * 4 + VATINSyntaxChecker._toInt(cArray[6]) * 3 + VATINSyntaxChecker._toInt(cArray[7]) * 2;
        int n2 = n % 11;
        if (n2 == 10) {
            return false;
        }
        int n3 = VATINSyntaxChecker._toInt(cArray[10], cArray[11]);
        if (n3 <= 0) {
            return false;
        }
        int n4 = VATINSyntaxChecker._toInt(cArray[8]);
        return n2 == n4;
    }

    public static boolean isValidVATIN_NL(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 12) {
            return false;
        }
        for (n = 0; n <= 8; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (cArray[9] != 'B') {
            return false;
        }
        for (n = 10; n <= 11; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (VATINSyntaxChecker._isNL_BSN(cArray)) {
            return true;
        }
        return ISO7064.Mod97.isValid("NL" + string);
    }

    public static boolean isValidVATIN_PT(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum1to9(cArray[0])) {
            return false;
        }
        for (n = 1; n <= 8; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 11 - (VATINSyntaxChecker._toInt(cArray[0]) * 9 + VATINSyntaxChecker._toInt(cArray[1]) * 8 + VATINSyntaxChecker._toInt(cArray[2]) * 7 + VATINSyntaxChecker._toInt(cArray[3]) * 6 + VATINSyntaxChecker._toInt(cArray[4]) * 5 + VATINSyntaxChecker._toInt(cArray[5]) * 4 + VATINSyntaxChecker._toInt(cArray[6]) * 3 + VATINSyntaxChecker._toInt(cArray[7]) * 2) % 11;
        int n2 = n == 10 || n == 11 ? 0 : n;
        int n3 = VATINSyntaxChecker._toInt(cArray[8]);
        return n2 == n3;
    }

    public static int _se_s(char c) {
        int n = VATINSyntaxChecker._toInt(c);
        return n / 5 + n * 2 % 10;
    }

    public static boolean isValidVATIN_SE(@Nonnull String string) {
        int n;
        int n2;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 12) {
            return false;
        }
        for (n2 = 0; n2 <= 11; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = VATINSyntaxChecker._toInt(cArray[10], cArray[11]);
        if (n2 < 1 || n2 > 94) {
            return false;
        }
        int n3 = VATINSyntaxChecker._se_s(cArray[0]) + VATINSyntaxChecker._se_s(cArray[2]) + VATINSyntaxChecker._se_s(cArray[4]) + VATINSyntaxChecker._se_s(cArray[6]) + VATINSyntaxChecker._se_s(cArray[8]);
        int n4 = (10 - (n3 + VATINSyntaxChecker._toInt(cArray[1]) + VATINSyntaxChecker._toInt(cArray[3]) + VATINSyntaxChecker._toInt(cArray[5]) + VATINSyntaxChecker._toInt(cArray[7])) % 10) % 10;
        return n4 == (n = VATINSyntaxChecker._toInt(cArray[9]));
    }

    private static boolean _cy_is1(char c) {
        return c == '0' || c == '1' || c == '3' || c == '4' || c == '5' || c == '9';
    }

    private static int _cy_odd(char c) {
        return CY_ODD[c - 48];
    }

    public static boolean isValidVATIN_CY(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        if (!VATINSyntaxChecker._cy_is1(cArray[0])) {
            return false;
        }
        for (n = 1; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (!VATINSyntaxChecker._isLetterOrNum(cArray[8])) {
            return false;
        }
        n = VATINSyntaxChecker._toInt(cArray[0], cArray[1]);
        if (n == 12) {
            return false;
        }
        int n2 = VATINSyntaxChecker._cy_odd(cArray[0]) + VATINSyntaxChecker._toInt(cArray[1]) + VATINSyntaxChecker._cy_odd(cArray[2]) + VATINSyntaxChecker._toInt(cArray[3]) + VATINSyntaxChecker._cy_odd(cArray[4]) + VATINSyntaxChecker._toInt(cArray[5]) + VATINSyntaxChecker._cy_odd(cArray[6]) + VATINSyntaxChecker._toInt(cArray[7]);
        char c = (char)(65 + n2 % 26);
        return c == cArray[8];
    }

    private static boolean _cz_isV1(@Nonnull char[] cArray) {
        int n;
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (cArray[0] == '9') {
            return false;
        }
        n = 8 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 6 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 4 * VATINSyntaxChecker._toInt(cArray[4]) + 3 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6]);
        int n2 = n % 11 == 0 ? n + 11 : VATINSyntaxChecker.ceilTo(n, 11);
        int n3 = (n2 - n) % 10;
        int n4 = VATINSyntaxChecker._toInt(cArray[7]);
        return n3 == n4;
    }

    private static boolean _cz_isV2(@Nonnull char[] cArray) {
        int n;
        int n2;
        if (cArray.length != 9) {
            return false;
        }
        for (n2 = 0; n2 <= 8; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = VATINSyntaxChecker._toInt(cArray[0], cArray[1]);
        if (n2 < 0 || n2 > 53) {
            return false;
        }
        int n3 = VATINSyntaxChecker._toInt(cArray[2], cArray[3]);
        if (!(n3 >= 1 && n3 <= 12 || n3 >= 51 && n3 <= 62)) {
            return false;
        }
        int n4 = n3 >= 51 ? n3 - 50 : n3;
        return VATINSyntaxChecker._isValidMonthDay(n4, n = VATINSyntaxChecker._toInt(cArray[4], cArray[5]));
    }

    private static boolean _cz_isV3(@Nonnull char[] cArray) {
        int n;
        if (cArray.length != 9) {
            return false;
        }
        for (n = 0; n <= 8; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (cArray[0] != '6') {
            return false;
        }
        n = 8 * VATINSyntaxChecker._toInt(cArray[1]) + 7 * VATINSyntaxChecker._toInt(cArray[2]) + 6 * VATINSyntaxChecker._toInt(cArray[3]) + 5 * VATINSyntaxChecker._toInt(cArray[4]) + 4 * VATINSyntaxChecker._toInt(cArray[5]) + 3 * VATINSyntaxChecker._toInt(cArray[6]) + 2 * VATINSyntaxChecker._toInt(cArray[7]);
        int n2 = n % 11 == 0 ? n + 11 : VATINSyntaxChecker.ceilTo(n, 11);
        int n3 = CZ_V3[n2 - n - 1];
        int n4 = VATINSyntaxChecker._toInt(cArray[8]);
        return n3 == n4;
    }

    public static boolean isValidVATIN_CZ(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (VATINSyntaxChecker._cz_isV1(cArray)) {
            return true;
        }
        if (VATINSyntaxChecker._cz_isV2(cArray)) {
            return true;
        }
        if (VATINSyntaxChecker._cz_isV3(cArray)) {
            return true;
        }
        if (cArray.length != 10) {
            return false;
        }
        for (int i = 0; i <= 9; ++i) {
            if (VATINSyntaxChecker._isNum(cArray[i])) continue;
            return false;
        }
        long l = VATINSyntaxChecker._toLong(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7], cArray[8], cArray[9]);
        if (l % 11L != 0L) {
            return false;
        }
        int n2 = VATINSyntaxChecker._toInt(cArray[0], cArray[1]);
        if ((n2 < 0 || n2 > CZ_YEAR_MAX) && n2 < 54) {
            return false;
        }
        int n3 = VATINSyntaxChecker._toInt(cArray[2], cArray[3]);
        if (!(n3 >= 1 && n3 <= 12 || n3 >= 21 && n3 <= 32 || n3 >= 51 && n3 <= 62 || n3 >= 71 && n3 <= 82)) {
            return false;
        }
        int n4 = n3 >= 71 ? n3 - 70 : (n3 >= 51 ? n3 - 50 : (n3 >= 21 ? n3 - 20 : n3));
        if (!VATINSyntaxChecker._isValidMonthDay(n4, n = VATINSyntaxChecker._toInt(cArray[4], cArray[5]))) {
            return false;
        }
        int n5 = n2 + n3 + n + VATINSyntaxChecker._toInt(cArray[6], cArray[7]) + VATINSyntaxChecker._toInt(cArray[8], cArray[9]);
        return n5 % 11 == 0;
    }

    public static boolean isValidVATIN_EE(@Nonnull String string) {
        int n;
        int n2;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 9) {
            return false;
        }
        for (n2 = 0; n2 <= 8; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = 3 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 1 * VATINSyntaxChecker._toInt(cArray[2]) + 3 * VATINSyntaxChecker._toInt(cArray[3]) + 7 * VATINSyntaxChecker._toInt(cArray[4]) + 1 * VATINSyntaxChecker._toInt(cArray[5]) + 3 * VATINSyntaxChecker._toInt(cArray[6]) + 7 * VATINSyntaxChecker._toInt(cArray[7]);
        int n3 = VATINSyntaxChecker.ceilTo(n2, 10);
        int n4 = n3 - n2;
        return n4 == (n = VATINSyntaxChecker._toInt(cArray[8]));
    }

    public static boolean isValidVATIN_HU(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 9 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 3 * VATINSyntaxChecker._toInt(cArray[2]) + 1 * VATINSyntaxChecker._toInt(cArray[3]) + 9 * VATINSyntaxChecker._toInt(cArray[4]) + 7 * VATINSyntaxChecker._toInt(cArray[5]) + 3 * VATINSyntaxChecker._toInt(cArray[6]);
        int n2 = n % 10;
        int n3 = n2 == 0 ? 0 : 10 - n2;
        int n4 = VATINSyntaxChecker._toInt(cArray[7]);
        return n3 == n4;
    }

    private static boolean _lt_isLegalPerson(@Nonnull char[] cArray) {
        int n;
        int n2;
        int n3;
        if (cArray.length != 9) {
            return false;
        }
        for (n3 = 0; n3 <= 6; ++n3) {
            if (VATINSyntaxChecker._isNum(cArray[n3])) continue;
            return false;
        }
        if (cArray[7] != '1') {
            return false;
        }
        if (!VATINSyntaxChecker._isNum(cArray[8])) {
            return false;
        }
        n3 = 1 * VATINSyntaxChecker._toInt(cArray[0]) + 2 * VATINSyntaxChecker._toInt(cArray[1]) + 3 * VATINSyntaxChecker._toInt(cArray[2]) + 4 * VATINSyntaxChecker._toInt(cArray[3]) + 5 * VATINSyntaxChecker._toInt(cArray[4]) + 6 * VATINSyntaxChecker._toInt(cArray[5]) + 7 * VATINSyntaxChecker._toInt(cArray[6]) + 8 * VATINSyntaxChecker._toInt(cArray[7]);
        int n4 = n3 % 11;
        int n5 = n4 != 10 ? n4 : ((n2 = (n = 3 * VATINSyntaxChecker._toInt(cArray[0]) + 4 * VATINSyntaxChecker._toInt(cArray[1]) + 5 * VATINSyntaxChecker._toInt(cArray[2]) + 6 * VATINSyntaxChecker._toInt(cArray[3]) + 7 * VATINSyntaxChecker._toInt(cArray[4]) + 8 * VATINSyntaxChecker._toInt(cArray[5]) + 9 * VATINSyntaxChecker._toInt(cArray[6]) + 1 * VATINSyntaxChecker._toInt(cArray[7])) % 11) == 10 ? 0 : n2);
        n = VATINSyntaxChecker._toInt(cArray[8]);
        return n5 == n;
    }

    public static boolean isValidVATIN_LT(@Nonnull String string) {
        int n;
        int n2;
        int n3;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (VATINSyntaxChecker._lt_isLegalPerson(cArray)) {
            return true;
        }
        if (cArray.length != 12) {
            return false;
        }
        for (n3 = 0; n3 <= 9; ++n3) {
            if (VATINSyntaxChecker._isNum(cArray[n3])) continue;
            return false;
        }
        if (cArray[10] != '1') {
            return false;
        }
        if (!VATINSyntaxChecker._isNum(cArray[11])) {
            return false;
        }
        n3 = 1 * VATINSyntaxChecker._toInt(cArray[0]) + 2 * VATINSyntaxChecker._toInt(cArray[1]) + 3 * VATINSyntaxChecker._toInt(cArray[2]) + 4 * VATINSyntaxChecker._toInt(cArray[3]) + 5 * VATINSyntaxChecker._toInt(cArray[4]) + 6 * VATINSyntaxChecker._toInt(cArray[5]) + 7 * VATINSyntaxChecker._toInt(cArray[6]) + 8 * VATINSyntaxChecker._toInt(cArray[7]) + 9 * VATINSyntaxChecker._toInt(cArray[8]) + 1 * VATINSyntaxChecker._toInt(cArray[9]) + 2 * VATINSyntaxChecker._toInt(cArray[10]);
        int n4 = n3 % 11;
        int n5 = n4 != 10 ? n4 : ((n2 = (n = 3 * VATINSyntaxChecker._toInt(cArray[0]) + 4 * VATINSyntaxChecker._toInt(cArray[1]) + 5 * VATINSyntaxChecker._toInt(cArray[2]) + 6 * VATINSyntaxChecker._toInt(cArray[3]) + 7 * VATINSyntaxChecker._toInt(cArray[4]) + 8 * VATINSyntaxChecker._toInt(cArray[5]) + 9 * VATINSyntaxChecker._toInt(cArray[6]) + 1 * VATINSyntaxChecker._toInt(cArray[7]) + 2 * VATINSyntaxChecker._toInt(cArray[8]) + 3 * VATINSyntaxChecker._toInt(cArray[9]) + 4 * VATINSyntaxChecker._toInt(cArray[10])) % 11) == 10 ? 0 : n2);
        n = VATINSyntaxChecker._toInt(cArray[11]);
        return n5 == n;
    }

    private static boolean _is_lvV1(@Nonnull char[] cArray) {
        int n;
        if (cArray.length != 11) {
            return false;
        }
        for (n = 0; n <= 10; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (VATINSyntaxChecker._toInt(cArray[0]) <= 3) {
            return false;
        }
        n = 9 * VATINSyntaxChecker._toInt(cArray[0]) + 1 * VATINSyntaxChecker._toInt(cArray[1]) + 4 * VATINSyntaxChecker._toInt(cArray[2]) + 8 * VATINSyntaxChecker._toInt(cArray[3]) + 3 * VATINSyntaxChecker._toInt(cArray[4]) + 10 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6]) + 5 * VATINSyntaxChecker._toInt(cArray[7]) + 7 * VATINSyntaxChecker._toInt(cArray[8]) + 6 * VATINSyntaxChecker._toInt(cArray[9]);
        int n2 = 3 - n % 11;
        if (n2 == -1) {
            return false;
        }
        int n3 = n2 < -1 ? n2 + 11 : n2;
        int n4 = VATINSyntaxChecker._toInt(cArray[10]);
        return n3 == n4;
    }

    public static boolean isValidVATIN_LV(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (VATINSyntaxChecker._is_lvV1(cArray)) {
            return true;
        }
        if (cArray.length != 11) {
            return false;
        }
        for (n = 0; n <= 10; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        if (VATINSyntaxChecker._toInt(cArray[0]) > 3) {
            return false;
        }
        n = VATINSyntaxChecker._toInt(cArray[0], cArray[1]);
        int n2 = VATINSyntaxChecker._toInt(cArray[2], cArray[3]);
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        return VATINSyntaxChecker._isValidMonthDay(n2, n);
    }

    public static boolean isValidVATIN_MT(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5]);
        if (n <= 100000) {
            return false;
        }
        int n2 = 3 * VATINSyntaxChecker._toInt(cArray[0]) + 4 * VATINSyntaxChecker._toInt(cArray[1]) + 6 * VATINSyntaxChecker._toInt(cArray[2]) + 7 * VATINSyntaxChecker._toInt(cArray[3]) + 8 * VATINSyntaxChecker._toInt(cArray[4]) + 9 * VATINSyntaxChecker._toInt(cArray[5]);
        int n3 = 37 - n2 % 37;
        int n4 = n3 == 0 ? 37 : n3;
        int n5 = VATINSyntaxChecker._toInt(cArray[6], cArray[7]);
        return n4 == n5;
    }

    public static boolean isValidVATIN_PL(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 10) {
            return false;
        }
        for (n = 0; n <= 9; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 6 * VATINSyntaxChecker._toInt(cArray[0]) + 5 * VATINSyntaxChecker._toInt(cArray[1]) + 7 * VATINSyntaxChecker._toInt(cArray[2]) + 2 * VATINSyntaxChecker._toInt(cArray[3]) + 3 * VATINSyntaxChecker._toInt(cArray[4]) + 4 * VATINSyntaxChecker._toInt(cArray[5]) + 5 * VATINSyntaxChecker._toInt(cArray[6]) + 6 * VATINSyntaxChecker._toInt(cArray[7]) + 7 * VATINSyntaxChecker._toInt(cArray[8]);
        int n2 = n % 11;
        if (n2 == 10) {
            return false;
        }
        int n3 = VATINSyntaxChecker._toInt(cArray[9]);
        return n2 == n3;
    }

    public static boolean isValidVATIN_SI(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 8) {
            return false;
        }
        for (n = 0; n <= 7; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = VATINSyntaxChecker._toInt(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6]);
        if (n < 1000000 || n > 9999999) {
            return false;
        }
        int n2 = 8 * VATINSyntaxChecker._toInt(cArray[0]) + 7 * VATINSyntaxChecker._toInt(cArray[1]) + 6 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 4 * VATINSyntaxChecker._toInt(cArray[4]) + 3 * VATINSyntaxChecker._toInt(cArray[5]) + 2 * VATINSyntaxChecker._toInt(cArray[6]);
        int n3 = 11 - n2 % 11;
        if (n3 == 11) {
            return false;
        }
        int n4 = n3 == 10 ? 0 : n3;
        int n5 = VATINSyntaxChecker._toInt(cArray[7]);
        return n4 == n5;
    }

    private static boolean _sk_is3(int n) {
        return n == 50 || n == 51 || n == 52 || n == 55 || n == 56 || n == 57;
    }

    public static boolean isValidVATIN_SK(@Nonnull String string) {
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 10) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum1to9(cArray[0])) {
            return false;
        }
        if (!VATINSyntaxChecker._isNum(cArray[1])) {
            return false;
        }
        if (!VATINSyntaxChecker._sk_is3(cArray[2])) {
            return false;
        }
        for (int i = 3; i <= 9; ++i) {
            if (VATINSyntaxChecker._isNum(cArray[i])) continue;
            return false;
        }
        long l = VATINSyntaxChecker._toLong(cArray[0], cArray[1], cArray[2], cArray[3], cArray[4], cArray[5], cArray[6], cArray[7], cArray[8], cArray[9]);
        return l % 11L == 0L;
    }

    private static boolean _bg_isV1(@Nonnull char[] cArray) {
        int n;
        int n2;
        int n3;
        if (cArray.length != 9) {
            return false;
        }
        for (n3 = 0; n3 <= 8; ++n3) {
            if (VATINSyntaxChecker._isNum(cArray[n3])) continue;
            return false;
        }
        n3 = 1 * VATINSyntaxChecker._toInt(cArray[0]) + 2 * VATINSyntaxChecker._toInt(cArray[1]) + 3 * VATINSyntaxChecker._toInt(cArray[2]) + 4 * VATINSyntaxChecker._toInt(cArray[3]) + 5 * VATINSyntaxChecker._toInt(cArray[4]) + 6 * VATINSyntaxChecker._toInt(cArray[5]) + 7 * VATINSyntaxChecker._toInt(cArray[6]) + 8 * VATINSyntaxChecker._toInt(cArray[7]);
        int n4 = n3 % 11;
        int n5 = n4 != 10 ? n4 : ((n2 = (n = 3 * VATINSyntaxChecker._toInt(cArray[0]) + 4 * VATINSyntaxChecker._toInt(cArray[1]) + 5 * VATINSyntaxChecker._toInt(cArray[2]) + 6 * VATINSyntaxChecker._toInt(cArray[3]) + 7 * VATINSyntaxChecker._toInt(cArray[4]) + 8 * VATINSyntaxChecker._toInt(cArray[5]) + 9 * VATINSyntaxChecker._toInt(cArray[6]) + 10 * VATINSyntaxChecker._toInt(cArray[7])) % 11) == 10 ? 0 : n2);
        n = VATINSyntaxChecker._toInt(cArray[8]);
        return n5 == n;
    }

    private static boolean _bg_isV2(@Nonnull char[] cArray) {
        int n;
        int n2;
        if (cArray.length != 10) {
            return false;
        }
        for (n2 = 0; n2 <= 9; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = VATINSyntaxChecker._toInt(cArray[2], cArray[3]) % 20;
        if (!VATINSyntaxChecker._isValidMonthDay(n2, n = VATINSyntaxChecker._toInt(cArray[4], cArray[5]))) {
            return false;
        }
        int n3 = 2 * VATINSyntaxChecker._toInt(cArray[0]) + 4 * VATINSyntaxChecker._toInt(cArray[1]) + 8 * VATINSyntaxChecker._toInt(cArray[2]) + 5 * VATINSyntaxChecker._toInt(cArray[3]) + 10 * VATINSyntaxChecker._toInt(cArray[4]) + 9 * VATINSyntaxChecker._toInt(cArray[5]) + 7 * VATINSyntaxChecker._toInt(cArray[6]) + 3 * VATINSyntaxChecker._toInt(cArray[7]) + 6 * VATINSyntaxChecker._toInt(cArray[8]);
        int n4 = n3 % 11;
        int n5 = n4 == 10 ? 0 : n4;
        int n6 = VATINSyntaxChecker._toInt(cArray[9]);
        return n5 == n6;
    }

    private static boolean _bg_isV3(@Nonnull char[] cArray) {
        int n;
        int n2;
        if (cArray.length != 10) {
            return false;
        }
        for (n2 = 0; n2 <= 9; ++n2) {
            if (VATINSyntaxChecker._isNum(cArray[n2])) continue;
            return false;
        }
        n2 = 21 * VATINSyntaxChecker._toInt(cArray[0]) + 19 * VATINSyntaxChecker._toInt(cArray[1]) + 17 * VATINSyntaxChecker._toInt(cArray[2]) + 13 * VATINSyntaxChecker._toInt(cArray[3]) + 11 * VATINSyntaxChecker._toInt(cArray[4]) + 9 * VATINSyntaxChecker._toInt(cArray[5]) + 7 * VATINSyntaxChecker._toInt(cArray[6]) + 3 * VATINSyntaxChecker._toInt(cArray[7]) + 1 * VATINSyntaxChecker._toInt(cArray[8]);
        int n3 = n2 % 10;
        return n3 == (n = VATINSyntaxChecker._toInt(cArray[9]));
    }

    public static boolean isValidVATIN_BG(@Nonnull String string) {
        int n;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (VATINSyntaxChecker._bg_isV1(cArray)) {
            return true;
        }
        if (VATINSyntaxChecker._bg_isV2(cArray)) {
            return true;
        }
        if (VATINSyntaxChecker._bg_isV3(cArray)) {
            return true;
        }
        if (cArray.length != 10) {
            return false;
        }
        for (n = 0; n <= 9; ++n) {
            if (VATINSyntaxChecker._isNum(cArray[n])) continue;
            return false;
        }
        n = 4 * VATINSyntaxChecker._toInt(cArray[0]) + 3 * VATINSyntaxChecker._toInt(cArray[1]) + 2 * VATINSyntaxChecker._toInt(cArray[2]) + 7 * VATINSyntaxChecker._toInt(cArray[3]) + 6 * VATINSyntaxChecker._toInt(cArray[4]) + 5 * VATINSyntaxChecker._toInt(cArray[5]) + 4 * VATINSyntaxChecker._toInt(cArray[6]) + 3 * VATINSyntaxChecker._toInt(cArray[7]) + 2 * VATINSyntaxChecker._toInt(cArray[8]);
        int n2 = 11 - n % 11;
        if (n2 == 10) {
            return false;
        }
        int n3 = n2 == 11 ? 0 : n2;
        int n4 = VATINSyntaxChecker._toInt(cArray[9]);
        return n3 == n4;
    }

    public static boolean isValidVATIN_RO(@Nonnull String string) {
        int n;
        int n2;
        int n3;
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length < 2 || cArray.length > 10) {
            return false;
        }
        char[] cArray2 = cArray;
        int n4 = cArray2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = cArray2[n3];
            if (VATINSyntaxChecker._isNum((char)n2)) continue;
            return false;
        }
        if (cArray.length < 10) {
            cArray = StringHelper.getLeadingZero(string, 10).toCharArray();
        }
        n2 = (n3 = (n4 = (n = 7 * VATINSyntaxChecker._toInt(cArray[0]) + 5 * VATINSyntaxChecker._toInt(cArray[1]) + 3 * VATINSyntaxChecker._toInt(cArray[2]) + 2 * VATINSyntaxChecker._toInt(cArray[3]) + 1 * VATINSyntaxChecker._toInt(cArray[4]) + 7 * VATINSyntaxChecker._toInt(cArray[5]) + 5 * VATINSyntaxChecker._toInt(cArray[6]) + 3 * VATINSyntaxChecker._toInt(cArray[7]) + 2 * VATINSyntaxChecker._toInt(cArray[8])) * 10) % 11) == 10 ? 0 : n3;
        int n5 = VATINSyntaxChecker._toInt(cArray[9]);
        return n2 == n5;
    }

    public static boolean isValidVATIN_HR(@Nonnull String string) {
        ValueEnforcer.notNull(string, "VATIN");
        char[] cArray = string.toCharArray();
        if (cArray.length != 11) {
            return false;
        }
        for (int i = 0; i <= 10; ++i) {
            if (VATINSyntaxChecker._isNum(cArray[i])) continue;
            return false;
        }
        return true;
    }

    static {
        s_aMap.put("AT", VATINSyntaxChecker::isValidVATIN_AT);
        s_aMap.put("BE", VATINSyntaxChecker::isValidVATIN_BE);
        s_aMap.put("BG", VATINSyntaxChecker::isValidVATIN_BG);
        s_aMap.put("CY", VATINSyntaxChecker::isValidVATIN_CY);
        s_aMap.put("CZ", VATINSyntaxChecker::isValidVATIN_CZ);
        s_aMap.put("DE", VATINSyntaxChecker::isValidVATIN_DE);
        s_aMap.put("DK", VATINSyntaxChecker::isValidVATIN_DK);
        s_aMap.put("EE", VATINSyntaxChecker::isValidVATIN_EE);
        s_aMap.put("EL", VATINSyntaxChecker::isValidVATIN_EL);
        s_aMap.put("GR", VATINSyntaxChecker::isValidVATIN_EL);
        s_aMap.put("ES", VATINSyntaxChecker::isValidVATIN_ES);
        s_aMap.put("FI", VATINSyntaxChecker::isValidVATIN_FI);
        s_aMap.put("FR", VATINSyntaxChecker::isValidVATIN_FR);
        s_aMap.put("GB", VATINSyntaxChecker::isValidVATIN_GB);
        s_aMap.put("HR", VATINSyntaxChecker::isValidVATIN_HR);
        s_aMap.put("HU", VATINSyntaxChecker::isValidVATIN_HU);
        s_aMap.put("IE", VATINSyntaxChecker::isValidVATIN_IE);
        s_aMap.put("IT", VATINSyntaxChecker::isValidVATIN_IT);
        s_aMap.put("LT", VATINSyntaxChecker::isValidVATIN_LT);
        s_aMap.put("LU", VATINSyntaxChecker::isValidVATIN_LU);
        s_aMap.put("LV", VATINSyntaxChecker::isValidVATIN_LV);
        s_aMap.put("MT", VATINSyntaxChecker::isValidVATIN_MT);
        s_aMap.put("NL", VATINSyntaxChecker::isValidVATIN_NL);
        s_aMap.put("PL", VATINSyntaxChecker::isValidVATIN_PL);
        s_aMap.put("PT", VATINSyntaxChecker::isValidVATIN_PT);
        s_aMap.put("RO", VATINSyntaxChecker::isValidVATIN_RO);
        s_aMap.put("SE", VATINSyntaxChecker::isValidVATIN_SE);
        s_aMap.put("SI", VATINSyntaxChecker::isValidVATIN_SI);
        s_aMap.put("SK", VATINSyntaxChecker::isValidVATIN_SK);
        ES_V2 = new char[]{'T', 'R', 'W', 'A', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E'};
        assert (ES_V2.length == 23);
        CY_ODD = new int[]{1, 0, 5, 7, 9, 13, 15, 17, 19, 21};
        CZ_V3 = new int[]{8, 7, 6, 5, 4, 3, 2, 1, 0, 9, 8};
        CZ_YEAR_MAX = PDTFactory.getCurrentYear() % 100;
    }
}

