/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy;

import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import com.helger.network.proxy.settings.IProxySettings;
import com.helger.network.proxy.settings.ProxySettingsManager;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorProxySettingsManager
extends Authenticator {
    public static final AuthenticatorProxySettingsManager INSTANCE = new AuthenticatorProxySettingsManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatorProxySettingsManager.class);

    public static void setAsDefault() {
        IPrivilegedAction.authenticatorSetDefault(INSTANCE).invokeSafe();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Using AuthenticatorProxySettingsManager as the default Authenticator");
        }
    }

    @Nullable
    protected PasswordAuthentication findProxyPasswordAuthentication(@Nullable String string, @Nullable InetAddress inetAddress, int n, @Nonnull String string2, @Nullable String string3, @Nonnull String string4, @Nullable URL uRL) {
        ICommonsOrderedSet<IProxySettings> iCommonsOrderedSet = ProxySettingsManager.findAllProxySettings(string2, string, n);
        for (IProxySettings iProxySettings : iCommonsOrderedSet) {
            PasswordAuthentication passwordAuthentication = iProxySettings.getAsPasswordAuthentication();
            if (passwordAuthentication == null) continue;
            return passwordAuthentication;
        }
        return null;
    }

    @Override
    @Nullable
    protected final PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
            return null;
        }
        return this.findProxyPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme(), this.getRequestingURL());
    }

    @Nullable
    public static PasswordAuthentication requestProxyPasswordAuthentication(@Nullable String string, @Nullable int n, @Nullable String string2) {
        return AuthenticatorProxySettingsManager.requestPasswordAuthentication(string, null, n, string2, null, null, null, Authenticator.RequestorType.PROXY);
    }
}

