/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.IURLProtocol;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.network.proxy.config.IProxySettingsPerProtocol;
import java.net.Proxy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHttpProxyType implements IProxySettingsPerProtocol
{
    HTTP("http", EURLProtocol.HTTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http")),
    HTTPS("https", EURLProtocol.HTTPS, SchemeDefaultPortMapper.getDefaultPortOrThrow("https")),
    FTP("ftp", EURLProtocol.FTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http"));

    private final String m_sID;
    private final IURLProtocol m_aURLProtocol;
    private final int m_nDefaultPort;

    private EHttpProxyType(@Nonnegative String string2, IURLProtocol iURLProtocol, int n2) {
        this.m_sID = string2;
        this.m_aURLProtocol = iURLProtocol;
        this.m_nDefaultPort = n2;
    }

    @Nonnull
    public Proxy.Type getProxyType() {
        return Proxy.Type.HTTP;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public IURLProtocol getURLProtocol() {
        return this.m_aURLProtocol;
    }

    @Override
    @Nonnegative
    public int getDefaultPort() {
        return this.m_nDefaultPort;
    }

    @Override
    @Nonnull
    public String getPropertyNameNoProxyHosts() {
        if (this == HTTPS) {
            return HTTP.getPropertyNameNoProxyHosts();
        }
        return this.m_sID + ".noProxyHosts";
    }

    @Nullable
    public static EHttpProxyType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EHttpProxyType.class, string);
    }

    @Nullable
    public static EHttpProxyType getFromURLProtocolOrDefault(@Nullable IURLProtocol iURLProtocol, @Nullable EHttpProxyType eHttpProxyType2) {
        return EnumHelper.findFirst(EHttpProxyType.class, eHttpProxyType -> eHttpProxyType.m_aURLProtocol.equals(iURLProtocol), eHttpProxyType2);
    }
}

