/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.id.IHasID;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.url.IURLProtocol;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IProxySettingsPerProtocol
extends IHasID<String> {
    @Nonnull
    public IURLProtocol getURLProtocol();

    @Nonnegative
    public int getDefaultPort();

    @Nonnull
    default public String getPropertyNameProxyHost() {
        return (String)this.getID() + ".proxyHost";
    }

    @Nullable
    default public String getProxyHost() {
        return SystemProperties.getPropertyValueOrNull(this.getPropertyNameProxyHost());
    }

    @Nonnull
    default public String getPropertyNameProxyPort() {
        return (String)this.getID() + ".proxyPort";
    }

    @CheckForSigned
    default public int getProxyPort() {
        return StringParser.parseInt(SystemProperties.getPropertyValueOrNull(this.getPropertyNameProxyPort()), -1);
    }

    @Nonnull
    default public String getPropertyNameProxyUserName() {
        return (String)this.getID() + ".proxyUser";
    }

    @Nullable
    default public String getProxyUserName() {
        return SystemProperties.getPropertyValueOrNull(this.getPropertyNameProxyUserName());
    }

    @Nonnull
    default public String getPropertyNameProxyPassword() {
        return (String)this.getID() + ".proxyPassword";
    }

    @Nullable
    default public String getProxyPassword() {
        return SystemProperties.getPropertyValueOrNull(this.getPropertyNameProxyPassword());
    }

    @Nonnull
    default public String getPropertyNameNoProxyHosts() {
        return (String)this.getID() + ".noProxyHosts";
    }

    @Nullable
    default public String getNoProxyHosts() {
        return SystemProperties.getPropertyValueOrNull(this.getPropertyNameNoProxyHosts());
    }
}

