/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.network.proxy.config.HttpProxyConfig;
import com.helger.network.proxy.config.IProxyConfig;
import com.helger.network.proxy.config.SocksProxyConfig;
import java.net.Proxy;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UseSystemProxyConfig
implements IProxyConfig {
    public static final String SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";

    public boolean isUseSystemProxies() {
        return StringParser.parseBool(SystemProperties.getPropertyValueOrNull(SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES), false);
    }

    @Override
    public void activateGlobally() {
        UseSystemProxyConfig.activateGloballyStatic();
    }

    public static void activateGloballyStatic() {
        HttpProxyConfig.deactivateGlobally();
        SocksProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue(SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES, Boolean.TRUE.toString());
    }

    public static void deactivateGlobally() {
        SystemProperties.removePropertyValue(SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES);
    }

    @Override
    @Nullable
    public Proxy getAsProxy() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

