/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PDIdentifier
implements Serializable {
    private final String m_sScheme;
    private final String m_sValue;

    public PDIdentifier(@Nullable String string, @Nullable String string2) {
        this.m_sScheme = string;
        this.m_sValue = string2;
    }

    @Nullable
    public String getScheme() {
        return this.m_sScheme;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute("scheme", this.m_sScheme);
        microElement.setAttribute("value", this.m_sValue);
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("scheme", this.m_sScheme);
        jsonObject.add("value", this.m_sValue);
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDIdentifier pDIdentifier = (PDIdentifier)object;
        return EqualsHelper.equals(this.m_sScheme, pDIdentifier.m_sScheme) && EqualsHelper.equals(this.m_sValue, pDIdentifier.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sScheme).append(this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Scheme", this.m_sScheme).append("Value", this.m_sValue).getToString();
    }
}

