/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.peppol.sml.ISMLInfo;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMLInfo
implements ISMLInfo,
ICloneable<SMLInfo> {
    public static final boolean DEFAULT_CLIENT_CERTIFICATE_REQUIRED = true;
    public static final ObjectType OT = new ObjectType("sml.info");
    private final String m_sID;
    private String m_sDisplayName;
    private String m_sDNSZone;
    private String m_sManagementServiceURL;
    private boolean m_bClientCertificateRequired;
    private URL m_aManageServiceMetaDataEndpointAddress;
    private URL m_aManageParticipantIdentifierEndpointAddress;

    public SMLInfo(@Nonnull ISMLInfo iSMLInfo) {
        this((String)iSMLInfo.getID(), iSMLInfo.getDisplayName(), iSMLInfo.getDNSZone(), iSMLInfo.getManagementServiceURL(), iSMLInfo.isClientCertificateRequired());
    }

    public SMLInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, boolean bl) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, string2, string3, bl);
    }

    public SMLInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, boolean bl) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.setDisplayName(string2);
        this.setDNSZone(string3);
        this.setManagementServiceURL(string4);
        this.setClientCertificateRequired(bl);
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public final EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DisplayName");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDNSZone() {
        return this.m_sDNSZone;
    }

    @Nonnull
    public final EChange setDNSZone(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DNSZone");
        if (string.equals(this.m_sDNSZone)) {
            return EChange.UNCHANGED;
        }
        this.m_sDNSZone = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getManagementServiceURL() {
        return this.m_sManagementServiceURL;
    }

    @Override
    @Nonnull
    public URL getManageServiceMetaDataEndpointAddress() {
        return this.m_aManageServiceMetaDataEndpointAddress;
    }

    @Override
    @Nonnull
    public URL getManageParticipantIdentifierEndpointAddress() {
        return this.m_aManageParticipantIdentifierEndpointAddress;
    }

    @Nonnull
    public final EChange setManagementServiceURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ManagementServiceURL");
        if (string.equals(this.m_sManagementServiceURL)) {
            return EChange.UNCHANGED;
        }
        this.m_sManagementServiceURL = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        try {
            this.m_aManageServiceMetaDataEndpointAddress = new URL(this.m_sManagementServiceURL + '/' + "manageservicemetadata");
            this.m_aManageParticipantIdentifierEndpointAddress = new URL(this.m_sManagementServiceURL + '/' + "manageparticipantidentifier");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Failed to convert to URL", malformedURLException);
        }
        return EChange.CHANGED;
    }

    @Override
    public boolean isClientCertificateRequired() {
        return this.m_bClientCertificateRequired;
    }

    @Nonnull
    public final EChange setClientCertificateRequired(boolean bl) {
        if (bl == this.m_bClientCertificateRequired) {
            return EChange.UNCHANGED;
        }
        this.m_bClientCertificateRequired = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SMLInfo getClone() {
        return new SMLInfo(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMLInfo sMLInfo = (SMLInfo)object;
        return this.m_sDNSZone.equals(sMLInfo.m_sDNSZone) && this.m_sManagementServiceURL.equals(sMLInfo.m_sManagementServiceURL) && this.m_bClientCertificateRequired == sMLInfo.m_bClientCertificateRequired;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sDNSZone).append(this.m_sManagementServiceURL).append(this.m_bClientCertificateRequired).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("DisplayName", this.m_sDisplayName).append("DNSZone", this.m_sDNSZone).append("ManagementServiceURL", this.m_sManagementServiceURL).append("ManageServiceMetaDataEndpointAddress", this.m_aManageServiceMetaDataEndpointAddress).append("ManageParticipantIdentifierEndpointAddress", this.m_aManageParticipantIdentifierEndpointAddress).append("ClientCertificateRequired", this.m_bClientCertificateRequired).getToString();
    }
}

