/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smp;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.type.ObjectType;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.smp.SMPTransportProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESMPTransportProfile implements ISMPTransportProfile
{
    TRANSPORT_PROFILE_START("busdox-transport-start", "START"){

        @Override
        public boolean isDeprecated() {
            return true;
        }
    }
    ,
    TRANSPORT_PROFILE_AS2("busdox-transport-as2-ver1p0", "Peppol AS2 v1"),
    TRANSPORT_PROFILE_AS2_V2("busdox-transport-as2-ver2p0", "Peppol AS2 v2"),
    TRANSPORT_PROFILE_AS4("busdox-transport-ebms3-as4", "AS4"){

        @Override
        public boolean isDeprecated() {
            return true;
        }
    }
    ,
    TRANSPORT_PROFILE_BDXR_AS4("bdxr-transport-ebms3-as4-v1p0", "CEF AS4"),
    TRANSPORT_PROFILE_PEPPOL_AS4("peppol-transport-as4-v1_0", "Peppol AS4 v1"){

        @Override
        public boolean isDeprecated() {
            return true;
        }
    }
    ,
    TRANSPORT_PROFILE_PEPPOL_AS4_V2("peppol-transport-as4-v2_0", "Peppol AS4 v2");

    private final String m_sID;
    private final String m_sName;

    private ESMPTransportProfile(String string2, String string3) {
        this.m_sID = string2;
        this.m_sName = string3;
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return SMPTransportProfile.OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nullable
    public static ESMPTransportProfile getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ESMPTransportProfile.class, string);
    }
}

