/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.codelists;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.codelists.PCLProcessIDType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentTypeType", propOrder={"comment", "processId"})
@CodingStyleguideUnaware
public class PCLDocumentTypeType
implements Serializable,
IExplicitlyCloneable {
    private String comment;
    @XmlElement(name="process-id", required=true)
    private List<PCLProcessIDType> processId;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="scheme", required=true)
    private String scheme;
    @XmlAttribute(name="value", required=true)
    private String value;
    @XmlAttribute(name="since", required=true)
    private String since;
    @XmlAttribute(name="deprecated", required=true)
    private boolean deprecated;
    @XmlAttribute(name="deprecated-since")
    private String deprecatedSince;
    @XmlAttribute(name="issued-by-openpeppol", required=true)
    private boolean issuedByOpenpeppol;
    @XmlAttribute(name="bis-version")
    private String bisVersion;
    @XmlAttribute(name="domain-community")
    private String domainCommunity;

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setComment(@Nullable String string) {
        this.comment = string;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PCLProcessIDType> getProcessId() {
        if (this.processId == null) {
            this.processId = new ArrayList<PCLProcessIDType>();
        }
        return this.processId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@Nullable String string) {
        this.scheme = string;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nullable String string) {
        this.value = string;
    }

    @Nullable
    public String getSince() {
        return this.since;
    }

    public void setSince(@Nullable String string) {
        this.since = string;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    @Nullable
    public String getDeprecatedSince() {
        return this.deprecatedSince;
    }

    public void setDeprecatedSince(@Nullable String string) {
        this.deprecatedSince = string;
    }

    public boolean isIssuedByOpenpeppol() {
        return this.issuedByOpenpeppol;
    }

    public void setIssuedByOpenpeppol(boolean bl) {
        this.issuedByOpenpeppol = bl;
    }

    @Nullable
    public String getBisVersion() {
        return this.bisVersion;
    }

    public void setBisVersion(@Nullable String string) {
        this.bisVersion = string;
    }

    @Nullable
    public String getDomainCommunity() {
        return this.domainCommunity;
    }

    public void setDomainCommunity(@Nullable String string) {
        this.domainCommunity = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PCLDocumentTypeType pCLDocumentTypeType = (PCLDocumentTypeType)object;
        if (!EqualsHelper.equals(this.bisVersion, pCLDocumentTypeType.bisVersion)) {
            return false;
        }
        if (!EqualsHelper.equals(this.comment, pCLDocumentTypeType.comment)) {
            return false;
        }
        if (!EqualsHelper.equals(this.deprecated, pCLDocumentTypeType.deprecated)) {
            return false;
        }
        if (!EqualsHelper.equals(this.deprecatedSince, pCLDocumentTypeType.deprecatedSince)) {
            return false;
        }
        if (!EqualsHelper.equals(this.domainCommunity, pCLDocumentTypeType.domainCommunity)) {
            return false;
        }
        if (!EqualsHelper.equals(this.issuedByOpenpeppol, pCLDocumentTypeType.issuedByOpenpeppol)) {
            return false;
        }
        if (!EqualsHelper.equals(this.name, pCLDocumentTypeType.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.processId, pCLDocumentTypeType.processId)) {
            return false;
        }
        if (!EqualsHelper.equals(this.scheme, pCLDocumentTypeType.scheme)) {
            return false;
        }
        if (!EqualsHelper.equals(this.since, pCLDocumentTypeType.since)) {
            return false;
        }
        return EqualsHelper.equals(this.value, pCLDocumentTypeType.value);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.bisVersion).append(this.comment).append(this.deprecated).append(this.deprecatedSince).append(this.domainCommunity).append(this.issuedByOpenpeppol).append(this.name).append(this.processId)).append(this.scheme).append(this.since).append(this.value).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("bisVersion", this.bisVersion).append("comment", this.comment).append("deprecated", this.deprecated).append("deprecatedSince", this.deprecatedSince).append("domainCommunity", this.domainCommunity).append("issuedByOpenpeppol", this.issuedByOpenpeppol).append("name", this.name).append("processId", this.processId).append("scheme", this.scheme).append("since", this.since).append("value", this.value).getToString();
    }

    public void setProcessId(@Nullable List<PCLProcessIDType> list) {
        this.processId = list;
    }

    public boolean hasProcessIdEntries() {
        return !this.getProcessId().isEmpty();
    }

    public boolean hasNoProcessIdEntries() {
        return this.getProcessId().isEmpty();
    }

    @Nonnegative
    public int getProcessIdCount() {
        return this.getProcessId().size();
    }

    @Nullable
    public PCLProcessIDType getProcessIdAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getProcessId().get(n);
    }

    public void addProcessId(@Nonnull PCLProcessIDType pCLProcessIDType) {
        this.getProcessId().add(pCLProcessIDType);
    }

    public void cloneTo(@Nonnull PCLDocumentTypeType pCLDocumentTypeType) {
        pCLDocumentTypeType.bisVersion = this.bisVersion;
        pCLDocumentTypeType.comment = this.comment;
        pCLDocumentTypeType.deprecated = this.deprecated;
        pCLDocumentTypeType.deprecatedSince = this.deprecatedSince;
        pCLDocumentTypeType.domainCommunity = this.domainCommunity;
        pCLDocumentTypeType.issuedByOpenpeppol = this.issuedByOpenpeppol;
        pCLDocumentTypeType.name = this.name;
        if (this.processId == null) {
            pCLDocumentTypeType.processId = null;
        } else {
            ArrayList<PCLProcessIDType> arrayList = new ArrayList<PCLProcessIDType>();
            for (PCLProcessIDType pCLProcessIDType : this.getProcessId()) {
                arrayList.add(pCLProcessIDType == null ? null : pCLProcessIDType.clone());
            }
            pCLDocumentTypeType.processId = arrayList;
        }
        pCLDocumentTypeType.scheme = this.scheme;
        pCLDocumentTypeType.since = this.since;
        pCLDocumentTypeType.value = this.value;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PCLDocumentTypeType clone() {
        PCLDocumentTypeType pCLDocumentTypeType = new PCLDocumentTypeType();
        this.cloneTo(pCLDocumentTypeType);
        return pCLDocumentTypeType;
    }
}

