/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import com.helger.peppolid.simple.doctype.BusdoxDocumentTypeIdentifierParts;
import com.helger.peppolid.simple.doctype.IBusdoxDocumentTypeIdentifierParts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolDocumentTypeIdentifierParts
implements IPeppolDocumentTypeIdentifierParts {
    public static final String VERSION_SEPARATOR = "::";
    private final IBusdoxDocumentTypeIdentifierParts m_aBusdoxParts;
    private final String m_sCustomizationID;
    private final String m_sVersion;

    @Nonnull
    private static String _buildSubTypeIdentifier(@Nonnull String string, @Nonnull String string2) {
        return string + VERSION_SEPARATOR + string2;
    }

    private PeppolDocumentTypeIdentifierParts(@Nonnull IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "CustomizationID");
        ValueEnforcer.notEmpty(string2, "Version");
        this.m_aBusdoxParts = iBusdoxDocumentTypeIdentifierParts;
        this.m_sCustomizationID = string;
        this.m_sVersion = string2;
    }

    public PeppolDocumentTypeIdentifierParts(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4) {
        this(new BusdoxDocumentTypeIdentifierParts(string, string2, PeppolDocumentTypeIdentifierParts._buildSubTypeIdentifier(string3, string4)), string3, string4);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getRootNS() {
        return this.m_aBusdoxParts.getRootNS();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_aBusdoxParts.getLocalName();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSubTypeIdentifier() {
        return this.m_aBusdoxParts.getSubTypeIdentifier();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsDocumentTypeIdentifierValue() {
        return this.m_aBusdoxParts.getAsDocumentTypeIdentifierValue();
    }

    public String toString() {
        return new ToStringGenerator(this).append("BusdoxParts", this.m_aBusdoxParts).append("CustomizationID", this.m_sCustomizationID).append("Version", this.m_sVersion).getToString();
    }

    @Nonnull
    public static IPeppolDocumentTypeIdentifierParts extractFromString(@Nonnull @Nonempty String string) {
        IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts = BusdoxDocumentTypeIdentifierParts.extractFromString(string);
        String string2 = iBusdoxDocumentTypeIdentifierParts.getSubTypeIdentifier();
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("The passed document identifier has an empty sub type identifier which is not PEPPOL compliant!");
        }
        String[] stringArray = RegExHelper.getSplitToArray(string2, VERSION_SEPARATOR, 2);
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' is missing the separation between customization ID and version!");
        }
        String string3 = stringArray[0];
        if (StringHelper.hasNoText(string3)) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' contains an empty customization ID!");
        }
        String string4 = stringArray[1];
        if (StringHelper.hasNoText(string4)) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' contains an empty version!");
        }
        return new PeppolDocumentTypeIdentifierParts(iBusdoxDocumentTypeIdentifierParts, string3, string4);
    }

    @Nullable
    public static IPeppolDocumentTypeIdentifierParts extractFromIdentifier(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "Identifier");
        return PeppolDocumentTypeIdentifierParts.extractFromString(iDocumentTypeIdentifier.getValue());
    }
}

