/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.pidscheme;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.pidscheme.EPredefinedParticipantIdentifierScheme;
import com.helger.peppolid.peppol.pidscheme.IParticipantIdentifierScheme;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ParticipantIdentifierSchemeManager {
    private static final ICommonsList<IParticipantIdentifierScheme> s_aPISchemes = new CommonsArrayList<IParticipantIdentifierScheme>();
    private static final ParticipantIdentifierSchemeManager s_aInstance;

    private ParticipantIdentifierSchemeManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsList<? extends IParticipantIdentifierScheme> getAllSchemes() {
        return (ICommonsList)s_aPISchemes.getClone();
    }

    @Nullable
    public static IParticipantIdentifierScheme getSchemeOfISO6523Code(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (IParticipantIdentifierScheme iParticipantIdentifierScheme : s_aPISchemes) {
                if (!iParticipantIdentifierScheme.getISO6523Code().equalsIgnoreCase(string)) continue;
                return iParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithISO6523Code(@Nullable String string) {
        return ParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string) != null;
    }

    @Nullable
    public static String getSchemeIDOfISO6523Code(@Nullable String string) {
        IParticipantIdentifierScheme iParticipantIdentifierScheme = ParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iParticipantIdentifierScheme == null ? null : iParticipantIdentifierScheme.getSchemeID();
    }

    @Nullable
    public static IParticipantIdentifierScheme getSchemeOfSchemeID(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (IParticipantIdentifierScheme iParticipantIdentifierScheme : s_aPISchemes) {
                if (!iParticipantIdentifierScheme.getSchemeID().equalsIgnoreCase(string)) continue;
                return iParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithSchemeID(@Nullable String string) {
        return ParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string) != null;
    }

    @Nullable
    public static String getISO6523CodeOfSchemeID(@Nullable String string) {
        IParticipantIdentifierScheme iParticipantIdentifierScheme = ParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iParticipantIdentifierScheme == null ? null : iParticipantIdentifierScheme.getISO6523Code();
    }

    @Nonnull
    public static ETriState isSchemeWithISO6523CodeDeprecated(@Nullable String string) {
        IParticipantIdentifierScheme iParticipantIdentifierScheme = ParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf(iParticipantIdentifierScheme.isDeprecated());
    }

    @Nonnull
    public static ETriState isSchemeWithSchemeIDDeprecated(@Nullable String string) {
        IParticipantIdentifierScheme iParticipantIdentifierScheme = ParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf(iParticipantIdentifierScheme.isDeprecated());
    }

    @Nullable
    public static IParticipantIdentifierScheme getSchemeOfIdentifier(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        String string;
        if (iParticipantIdentifier != null && iParticipantIdentifier.hasScheme(PeppolIdentifierFactory.INSTANCE.getDefaultParticipantIdentifierScheme()) && (string = iParticipantIdentifier.getValue()).length() > 5) {
            return ParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string.substring(0, 4));
        }
        return null;
    }

    static {
        for (EPredefinedParticipantIdentifierScheme ePredefinedParticipantIdentifierScheme : EPredefinedParticipantIdentifierScheme.values()) {
            s_aPISchemes.add(ePredefinedParticipantIdentifierScheme);
        }
        s_aInstance = new ParticipantIdentifierSchemeManager();
    }
}

