/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.process;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.ProcessIdentifierType;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolProcessIdentifier
extends ProcessIdentifierType
implements IPeppolIdentifier,
IProcessIdentifier,
IMutableIdentifier,
Comparable<PeppolProcessIdentifier>,
ICloneable<PeppolProcessIdentifier> {
    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isProcessIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Process identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isProcessIdentifierValueValid(string)) {
            throw new IllegalArgumentException("Peppol Process identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@Nonnull IProcessIdentifier iProcessIdentifier) {
        this(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@Nonnull String string, @Nonnull String string2) {
        this(true, PeppolProcessIdentifier._verifyScheme(string), PeppolProcessIdentifier._verifyValue(string2));
    }

    protected PeppolProcessIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("cenbii-procid-ubl");
    }

    @Override
    public int compareTo(@Nonnull PeppolProcessIdentifier peppolProcessIdentifier) {
        int n = CompareHelper.compare(this.getScheme(), peppolProcessIdentifier.getScheme());
        if (n == 0) {
            n = CompareHelper.compare(this.getValue(), peppolProcessIdentifier.getValue());
        }
        return n;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PeppolProcessIdentifier getClone() {
        return new PeppolProcessIdentifier(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nullable
    public static PeppolProcessIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (PeppolIdentifierFactory.INSTANCE.isProcessIdentifierSchemeValid(string) && PeppolIdentifierFactory.INSTANCE.isProcessIdentifierValueValid(string2)) {
            return new PeppolProcessIdentifier(true, string, string2);
        }
        return null;
    }
}

