/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.simple.process;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.ProcessIdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleProcessIdentifier
extends ProcessIdentifierType
implements IProcessIdentifier,
IMutableIdentifier,
Comparable<SimpleProcessIdentifier>,
ICloneable<SimpleProcessIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public SimpleProcessIdentifier(@Nonnull IProcessIdentifier iProcessIdentifier) {
        this(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public SimpleProcessIdentifier(@Nullable String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull SimpleProcessIdentifier simpleProcessIdentifier) {
        int n = CompareHelper.compare(this.getScheme(), simpleProcessIdentifier.getScheme());
        if (n == 0) {
            n = CompareHelper.compare(this.getValue(), simpleProcessIdentifier.getValue());
        }
        return n;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SimpleProcessIdentifier getClone() {
        return new SimpleProcessIdentifier(this);
    }

    @Nonnull
    public static SimpleProcessIdentifier wrap(@Nonnull ProcessIdentifierType processIdentifierType) {
        return new SimpleProcessIdentifier(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    public static SimpleProcessIdentifier wrap(@Nonnull com.helger.xsds.bdxr.smp1.ProcessIdentifierType processIdentifierType) {
        return new SimpleProcessIdentifier(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    public static SimpleProcessIdentifier wrap(@Nonnull IdentifierType identifierType) {
        return new SimpleProcessIdentifier(identifierType.getSchemeID(), identifierType.getValue());
    }
}

