/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EAS4CompressionMode implements IHasID<String>
{
    GZIP("gzip", CMimeType.APPLICATION_GZIP, ".gz"){

        @Override
        @Nonnull
        public InputStream getDecompressStream(@Nonnull InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream);
        }

        @Override
        @Nonnull
        public OutputStream getCompressStream(@Nonnull OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    };

    private final String m_sID;
    private final IMimeType m_aMimeType;
    private final String m_sFileExtension;

    private EAS4CompressionMode(@Nonnull @Nonempty String string2, IMimeType iMimeType, String string3) {
        this.m_sID = string2;
        this.m_aMimeType = iMimeType;
        this.m_sFileExtension = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    @Nonempty
    public String getMimeTypeAsString() {
        return this.m_aMimeType.getAsString();
    }

    @Nonnull
    @Nonempty
    public String getFileExtension() {
        return this.m_sFileExtension;
    }

    @Nonnull
    public abstract InputStream getDecompressStream(@Nonnull InputStream var1) throws IOException;

    @Nonnull
    public abstract OutputStream getCompressStream(@Nonnull OutputStream var1) throws IOException;

    @Nullable
    public static EAS4CompressionMode getFromMimeTypeStringOrNull(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EAS4CompressionMode.class, eAS4CompressionMode -> eAS4CompressionMode.getMimeTypeAsString().equals(string));
    }

    @Nullable
    public static EAS4CompressionMode getFromIDOrNull(String string) {
        return EnumHelper.getFromIDOrNull(EAS4CompressionMode.class, string);
    }
}

