/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Phase4OutgoingAttachment {
    private final ByteArrayWrapper m_aData;
    private final String m_sContentID;
    private final String m_sFilename;
    private final IMimeType m_aMimeType;
    private final EAS4CompressionMode m_eCompressionMode;

    public Phase4OutgoingAttachment(@Nonnull ByteArrayWrapper byteArrayWrapper, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode) {
        ValueEnforcer.notNull(byteArrayWrapper, "SrcData");
        ValueEnforcer.notNull(iMimeType, "MimeType");
        this.m_aData = byteArrayWrapper;
        this.m_sContentID = string;
        this.m_sFilename = string2;
        this.m_aMimeType = iMimeType;
        this.m_eCompressionMode = eAS4CompressionMode;
    }

    @Nonnull
    public ByteArrayWrapper getData() {
        return this.m_aData;
    }

    @Nullable
    public String getContentID() {
        return this.m_sContentID;
    }

    @Nullable
    public String getFilename() {
        return this.m_sFilename;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nullable
    public EAS4CompressionMode getCompressionMode() {
        return this.m_eCompressionMode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Data", this.m_aData).append("ContentID", this.m_sContentID).append("Filename", this.m_sFilename).append("MimeType", this.m_aMimeType).append("CompressionMode", this.m_eCompressionMode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteArrayWrapper m_aData;
        private String m_sContentID;
        private String m_sFilename;
        private IMimeType m_aMimeType;
        private EAS4CompressionMode m_eCompressionMode;

        @Nonnull
        public Builder data(@Nullable byte[] byArray) {
            return this.data(byArray == null ? null : new ByteArrayWrapper(byArray, false));
        }

        @Nonnull
        public Builder data(@Nullable ByteArrayWrapper byteArrayWrapper) {
            this.m_aData = byteArrayWrapper;
            return this;
        }

        @Nonnull
        public Builder reandomContentID() {
            return this.contentID(MessageHelperMethods.createRandomContentID());
        }

        @Nonnull
        public Builder contentID(@Nullable String string) {
            this.m_sContentID = string;
            return this;
        }

        @Nonnull
        public Builder filename(@Nullable String string) {
            this.m_sFilename = string;
            return this;
        }

        @Nonnull
        public Builder mimeTypeXML() {
            return this.mimeType(CMimeType.APPLICATION_XML);
        }

        @Nonnull
        public Builder mimeType(@Nullable IMimeType iMimeType) {
            this.m_aMimeType = iMimeType;
            return this;
        }

        @Nonnull
        public Builder compressionGZIP() {
            return this.compression(EAS4CompressionMode.GZIP);
        }

        @Nonnull
        public Builder compression(@Nullable EAS4CompressionMode eAS4CompressionMode) {
            this.m_eCompressionMode = eAS4CompressionMode;
            return this;
        }

        @Nonnull
        public Phase4OutgoingAttachment build() {
            return new Phase4OutgoingAttachment(this.m_aData, this.m_sContentID, this.m_sFilename, this.m_aMimeType, this.m_eCompressionMode);
        }
    }
}

