/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.mail.datasource.InputStreamProviderDataSource;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IAS4Attachment;
import com.helger.phase4.attachment.Phase4OutgoingAttachment;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.wss4j.common.ext.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class WSS4JAttachment
extends Attachment
implements IAS4Attachment {
    public static final String CONTENT_DESCRIPTION_ATTACHMENT = "Attachment";
    public static final String CONTENT_ID_PREFIX = "<attachment=";
    public static final String CONTENT_ID_SUFFIX = ">";
    private static final Logger LOGGER = LoggerFactory.getLogger(WSS4JAttachment.class);
    private final AS4ResourceHelper m_aResHelper;
    private IHasInputStream m_aISP;
    private EContentTransferEncoding m_eCTE = EContentTransferEncoding.BINARY;
    private EAS4CompressionMode m_eCompressionMode;
    private Charset m_aCharset;
    private String m_sUncompressedMimeType;

    public WSS4JAttachment(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable String string) {
        this.m_aResHelper = ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        this.overwriteMimeType(string);
    }

    @Nonnull
    public final AS4ResourceHelper getResHelper() {
        return this.m_aResHelper;
    }

    public void setUniqueID() {
        this.setId(MessageHelperMethods.createRandomAttachmentID());
    }

    @Override
    @Deprecated
    public final void setMimeType(@Nullable String string) {
        throw new UnsupportedOperationException();
    }

    public final void overwriteMimeType(@Nullable String string) {
        super.setMimeType(string);
        this.m_sUncompressedMimeType = string;
        this.addHeader("Content-Type", string);
    }

    @Override
    public final void addHeader(String string, String string2) {
        super.addHeader(string, string2);
    }

    @Override
    @Nullable
    public String getUncompressedMimeType() {
        return this.m_sUncompressedMimeType;
    }

    @Override
    @Nonnull
    public InputStream getSourceStream() {
        return this.getSourceStream(this.m_aResHelper);
    }

    @Override
    @Nonnull
    public InputStream getSourceStream(@Nonnull AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull(aS4ResourceHelper, "ResourceHelper");
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("Got no InputStream from " + this.m_aISP);
        }
        aS4ResourceHelper.addCloseable(inputStream);
        return inputStream;
    }

    @Override
    @Deprecated
    public void setSourceStream(InputStream inputStream) {
        throw new UnsupportedOperationException("Use setSourceStreamProvider instead");
    }

    @Override
    @Nullable
    public IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    public void setSourceStreamProvider(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        this.m_aISP = iHasInputStream;
    }

    @Override
    @Nonnull
    public final EContentTransferEncoding getContentTransferEncoding() {
        return this.m_eCTE;
    }

    @Nonnull
    public final WSS4JAttachment setContentTransferEncoding(@Nonnull EContentTransferEncoding eContentTransferEncoding) {
        this.m_eCTE = ValueEnforcer.notNull(eContentTransferEncoding, "CTE");
        return this;
    }

    @Override
    @Nullable
    public final EAS4CompressionMode getCompressionMode() {
        return this.m_eCompressionMode;
    }

    @Nonnull
    public final WSS4JAttachment setCompressionMode(@Nonnull EAS4CompressionMode eAS4CompressionMode) {
        ValueEnforcer.notNull(eAS4CompressionMode, "CompressionMode");
        this.m_eCompressionMode = eAS4CompressionMode;
        if (eAS4CompressionMode != null) {
            super.setMimeType(eAS4CompressionMode.getMimeType().getAsString());
        } else {
            super.setMimeType(this.m_sUncompressedMimeType);
        }
        return this;
    }

    @Override
    @Nullable
    public final Charset getCharsetOrDefault(@Nullable Charset charset) {
        return this.m_aCharset != null ? this.m_aCharset : charset;
    }

    @Override
    public final boolean hasCharset() {
        return this.m_aCharset != null;
    }

    @Nonnull
    public final WSS4JAttachment setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    private DataSource _getAsDataSource() {
        InputStreamProviderDataSource inputStreamProviderDataSource = new InputStreamProviderDataSource(this.m_aISP, this.getId(), this.getMimeType());
        return inputStreamProviderDataSource.getEncodingAware(this.getContentTransferEncoding());
    }

    public void addToMimeMultipart(@Nonnull MimeMultipart mimeMultipart) throws MessagingException {
        ValueEnforcer.notNull(mimeMultipart, "MimeMultipart");
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            String string = entry.getKey();
            if (string.equals("Content-ID") || string.equals("Content-Transfer-Encoding") || string.equals("Content-Type")) continue;
            mimeBodyPart.setHeader(string, entry.getValue());
        }
        Object object = this.getId();
        if (StringHelper.hasText((String)object)) {
            if (((String)object).charAt(0) != '<') {
                object = '<' + (String)object + '>';
            }
            mimeBodyPart.setHeader("Content-ID", (String)object);
        }
        mimeBodyPart.setDataHandler(new DataHandler(this._getAsDataSource()));
        mimeBodyPart.setHeader("Content-Type", this.getMimeType());
        mimeBodyPart.setHeader("Content-Transfer-Encoding", this.getContentTransferEncoding().getID());
        mimeMultipart.addBodyPart(mimeBodyPart);
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.getId()).append("MimeType", this.getMimeType()).append("Headers", this.getHeaders()).append("ResourceManager", this.m_aResHelper).append("ISP", this.m_aISP).append("CTE", this.m_eCTE).append("CM", this.m_eCompressionMode).append("Charset", this.m_aCharset).getToString();
    }

    private static void _addOutgoingHeaders(@Nonnull WSS4JAttachment wSS4JAttachment, @Nullable String string) {
        if (StringHelper.hasNoText(wSS4JAttachment.getId())) {
            wSS4JAttachment.setUniqueID();
        }
        wSS4JAttachment.addHeader("Content-Description", CONTENT_DESCRIPTION_ATTACHMENT);
        if (StringHelper.hasText(string)) {
            if (string.indexOf(34) >= 0) {
                LOGGER.warn("The filename '" + string + "' contains a double quote which will most likely break the Content-Disposition");
            }
            wSS4JAttachment.addHeader("Content-Disposition", "attachment; filename=\"" + string + "\"");
        }
        wSS4JAttachment.addHeader("Content-ID", CONTENT_ID_PREFIX + wSS4JAttachment.getId() + CONTENT_ID_SUFFIX);
        wSS4JAttachment.addHeader("Content-Type", wSS4JAttachment.getMimeType());
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull File file, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws IOException {
        String string = null;
        return WSS4JAttachment.createOutgoingFileAttachment(file, string, iMimeType, eAS4CompressionMode, aS4ResourceHelper);
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull File file, @Nullable String string, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) throws IOException {
        String string2 = FilenameHelper.getWithoutPath(file);
        return WSS4JAttachment.createOutgoingFileAttachment(file, string, string2, iMimeType, eAS4CompressionMode, aS4ResourceHelper);
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull File file, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) throws IOException {
        File file2;
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(iMimeType, "MimeType");
        WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, iMimeType.getAsString());
        wSS4JAttachment.setId(string);
        WSS4JAttachment._addOutgoingHeaders(wSS4JAttachment, string2);
        if (eAS4CompressionMode != null) {
            wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
            file2 = aS4ResourceHelper.createTempFile();
            try (OutputStream outputStream = eAS4CompressionMode.getCompressStream(FileHelper.getBufferedOutputStream(file2));){
                StreamHelper.copyInputStreamToOutputStream(FileHelper.getBufferedInputStream(file), outputStream);
            }
        } else {
            file2 = file;
        }
        wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> FileHelper.getBufferedInputStream(file2)));
        return wSS4JAttachment;
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull Phase4OutgoingAttachment phase4OutgoingAttachment, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) throws IOException {
        return WSS4JAttachment.createOutgoingFileAttachment(phase4OutgoingAttachment.getData().bytes(), phase4OutgoingAttachment.getContentID(), phase4OutgoingAttachment.getFilename(), phase4OutgoingAttachment.getMimeType(), phase4OutgoingAttachment.getCompressionMode(), aS4ResourceHelper);
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull byte[] byArray, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws IOException {
        ValueEnforcer.notNull(byArray, "Data");
        ValueEnforcer.notNull(iMimeType, "MimeType");
        WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, iMimeType.getAsString());
        wSS4JAttachment.setId(string);
        WSS4JAttachment._addOutgoingHeaders(wSS4JAttachment, string2);
        if (eAS4CompressionMode != null) {
            wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
            File file = aS4ResourceHelper.createTempFile();
            try (OutputStream outputStream = eAS4CompressionMode.getCompressStream(FileHelper.getBufferedOutputStream(file));){
                outputStream.write(byArray);
            }
            wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> FileHelper.getBufferedInputStream(file)));
        } else {
            wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> new NonBlockingByteArrayInputStream(byArray)));
        }
        return wSS4JAttachment;
    }

    public static boolean canBeKeptInMemory(long l) {
        return l <= 65536L;
    }

    @Nonnull
    public static WSS4JAttachment createIncomingFileAttachment(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws MessagingException, IOException {
        Object object;
        ValueEnforcer.notNull(mimeBodyPart, "BodyPart");
        ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, mimeBodyPart.getContentType());
        Object object2 = StringHelper.trimStartAndEnd(mimeBodyPart.getContentID(), '<', '>');
        wSS4JAttachment.setId((String)object2);
        if (WSS4JAttachment.canBeKeptInMemory(mimeBodyPart.getSize())) {
            object2 = mimeBodyPart.getDataHandler();
            object = ((DataHandler)object2).getDataSource();
            if (object != null) {
                wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> WSS4JAttachment.lambda$createIncomingFileAttachment$90ac481b$1((DataSource)object)));
            } else {
                LOGGER.warn("Having a DataHandler that can be read only once: " + object2);
                wSS4JAttachment.setSourceStreamProvider(HasInputStream.once(() -> {
                    try {
                        return object2.getInputStream();
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                }));
            }
        } else {
            object2 = aS4ResourceHelper.createTempFile();
            object = FileHelper.getBufferedOutputStream((File)object2);
            Throwable throwable = null;
            try {
                mimeBodyPart.getDataHandler().writeTo((OutputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)object).close();
                    }
                }
            }
            wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> FileHelper.getBufferedInputStream(object2)));
        }
        object2 = mimeBodyPart.getAllHeaders();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            wSS4JAttachment.addHeader(((Header)object).getName(), ((Header)object).getValue());
        }
        wSS4JAttachment.addHeader("Content-Description", CONTENT_DESCRIPTION_ATTACHMENT);
        wSS4JAttachment.addHeader("Content-ID", CONTENT_ID_PREFIX + wSS4JAttachment.getId() + CONTENT_ID_SUFFIX);
        wSS4JAttachment.addHeader("Content-Type", wSS4JAttachment.getMimeType());
        return wSS4JAttachment;
    }

    private static /* synthetic */ InputStream lambda$createIncomingFileAttachment$90ac481b$1(DataSource dataSource) {
        try {
            return dataSource.getInputStream();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

