/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.util.AS4ResourceHelper;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSS4JAttachmentCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSS4JAttachmentCallbackHandler.class);
    private final ICommonsOrderedMap<String, WSS4JAttachment> m_aAttachmentMap = new CommonsLinkedHashMap<String, WSS4JAttachment>();
    private final AS4ResourceHelper m_aResHelper;

    public WSS4JAttachmentCallbackHandler(@Nullable Iterable<? extends WSS4JAttachment> iterable, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        if (iterable != null) {
            for (WSS4JAttachment wSS4JAttachment : iterable) {
                this.m_aAttachmentMap.put(wSS4JAttachment.getId(), wSS4JAttachment);
            }
        }
        this.m_aResHelper = aS4ResourceHelper;
    }

    @Nonnull
    public final AS4ResourceHelper getResourceHelper() {
        return this.m_aResHelper;
    }

    @Nonnull
    @ReturnsMutableCopy
    private ICommonsList<Attachment> _getAttachmentsToAdd(@Nullable String string) {
        WSS4JAttachment wSS4JAttachment = (WSS4JAttachment)this.m_aAttachmentMap.get(string);
        if (wSS4JAttachment != null) {
            return new CommonsArrayList<Attachment>(wSS4JAttachment);
        }
        return new CommonsArrayList(this.m_aAttachmentMap.values());
    }

    @Override
    public void handle(@Nonnull Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            Object object;
            Object object2;
            Callback callback2;
            if (callback instanceof AttachmentRequestCallback) {
                callback2 = (AttachmentRequestCallback)callback;
                object2 = ((AttachmentRequestCallback)callback2).getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Requesting attachment ID '" + (String)object2 + "'");
                }
                if ((object = this._getAttachmentsToAdd((String)object2)).isEmpty()) {
                    throw new IllegalStateException("No attachments present for ID '" + (String)object2 + "'");
                }
                ((AttachmentRequestCallback)callback2).setAttachments((List<Attachment>)object);
                continue;
            }
            if (callback instanceof AttachmentResultCallback) {
                WSS4JAttachment wSS4JAttachment;
                callback2 = (AttachmentResultCallback)callback;
                object2 = ((AttachmentResultCallback)callback2).getAttachment();
                object = ((AttachmentResultCallback)callback2).getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resulting attachment ID '" + (String)object + "'");
                }
                if ((wSS4JAttachment = (WSS4JAttachment)this.m_aAttachmentMap.get(object)) == null) {
                    throw new IllegalStateException("Failed to resolve source attachment with ID '" + (String)object + "'");
                }
                WSS4JAttachment wSS4JAttachment2 = new WSS4JAttachment(this.m_aResHelper, ((Attachment)object2).getMimeType());
                wSS4JAttachment2.setId((String)object);
                wSS4JAttachment2.addHeaders(((Attachment)object2).getHeaders());
                wSS4JAttachment2.setCharset(wSS4JAttachment.getCharsetOrDefault(null));
                wSS4JAttachment2.setSourceStreamProvider(HasInputStream.once(((Attachment)object2)::getSourceStream));
                this.m_aAttachmentMap.put(object, wSS4JAttachment2);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback of class " + callback.getClass().getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllResponseAttachments() {
        return this.m_aAttachmentMap.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, WSS4JAttachment> responseAttachments() {
        return this.m_aAttachmentMap;
    }
}

