/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.cef;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phase4.cef.IPhase4CEFEndpointDetailProvider;
import com.helger.phase4.cef.Phase4CEFException;
import com.helger.phase4.cef.Phase4CEFSMPException;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.bdxr1.IBDXRServiceMetadataProvider;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.xsds.bdxr.smp1.EndpointType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Phase4CEFEndpointDetailProviderBDXR
implements IPhase4CEFEndpointDetailProvider {
    public static final ISMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_BDXR_AS4;
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4CEFEndpointDetailProviderBDXR.class);
    private final IBDXRServiceMetadataProvider m_aSMPClient;
    private ISMPTransportProfile m_aTP = DEFAULT_TRANSPORT_PROFILE;
    private EndpointType m_aEndpoint;

    public Phase4CEFEndpointDetailProviderBDXR(@Nonnull IBDXRServiceMetadataProvider iBDXRServiceMetadataProvider) {
        ValueEnforcer.notNull(iBDXRServiceMetadataProvider, "SMPClient");
        this.m_aSMPClient = iBDXRServiceMetadataProvider;
    }

    @Nonnull
    public final IBDXRServiceMetadataProvider getServiceMetadataProvider() {
        return this.m_aSMPClient;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTP;
    }

    @Nonnull
    public final Phase4CEFEndpointDetailProviderBDXR setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        this.m_aTP = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final EndpointType getEndpoint() {
        return this.m_aEndpoint;
    }

    @Override
    public void init(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws Phase4CEFException {
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocTypeID");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcID");
        ValueEnforcer.notNull(iParticipantIdentifier, "ReceiverID");
        if (this.m_aEndpoint == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start performing SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ")");
            }
            try {
                this.m_aEndpoint = this.m_aSMPClient.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_aTP);
                if (this.m_aEndpoint == null) {
                    throw new Phase4CEFSMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully resolved SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
            }
            catch (SMPClientException sMPClientException) {
                throw new Phase4CEFSMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")", sMPClientException);
            }
        }
    }

    @Override
    @Nullable
    public X509Certificate getReceiverAPCertificate() throws Phase4CEFException {
        try {
            return BDXRClientReadOnly.getEndpointCertificate(this.m_aEndpoint);
        }
        catch (CertificateException certificateException) {
            throw new Phase4CEFException("Failed to extract AP certificate from SMP endpoint: " + this.m_aEndpoint, certificateException);
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getReceiverAPEndpointURL() throws Phase4CEFException {
        String string = BDXRClientReadOnly.getEndpointAddress(this.m_aEndpoint);
        if (StringHelper.hasNoText(string)) {
            throw new Phase4CEFException("Failed to determine the destination URL from the SMP endpoint: " + this.m_aEndpoint);
        }
        return string;
    }
}

