/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.cef;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.ESuccess;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.phase4.cef.IPhase4CEFEndpointDetailProvider;
import com.helger.phase4.cef.Phase4CEFEndpointDetailProviderBDXR;
import com.helger.phase4.cef.Phase4CEFEndpointDetailProviderConstant;
import com.helger.phase4.cef.Phase4CEFHttpClientSettings;
import com.helger.phase4.model.MessageProperty;
import com.helger.phase4.sender.AbstractAS4UserMessageBuilderMIMEPayload;
import com.helger.phase4.util.Phase4Exception;
import com.helger.smpclient.bdxr1.IBDXRServiceMetadataProvider;
import com.helger.smpclient.url.BDXLURLProvider;
import com.helger.smpclient.url.IBDXLURLProvider;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class Phase4CEFSender {
    public static final SimpleIdentifierFactory IF = SimpleIdentifierFactory.INSTANCE;
    public static final IBDXLURLProvider URL_PROVIDER = BDXLURLProvider.INSTANCE;
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4CEFSender.class);

    private Phase4CEFSender() {
    }

    @Nonnull
    public static CEFUserMessageBuilder builder() {
        return new CEFUserMessageBuilder();
    }

    public static class CEFUserMessageBuilder
    extends AbstractCEFUserMessageBuilder<CEFUserMessageBuilder> {
    }

    public static abstract class AbstractCEFUserMessageBuilder<IMPLTYPE extends AbstractCEFUserMessageBuilder<IMPLTYPE>>
    extends AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE> {
        protected IParticipantIdentifier m_aSenderID;
        protected IParticipantIdentifier m_aReceiverID;
        protected IDocumentTypeIdentifier m_aDocTypeID;
        protected IProcessIdentifier m_aProcessID;
        protected IPhase4CEFEndpointDetailProvider m_aEndpointDetailProvider;
        protected Consumer<X509Certificate> m_aCertificateConsumer;
        protected Consumer<String> m_aAPEndointURLConsumer;

        protected AbstractCEFUserMessageBuilder() {
            try {
                this.httpClientFactory(new Phase4CEFHttpClientSettings());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to init AS4 Client builder", exception);
            }
        }

        @Nonnull
        public final IMPLTYPE senderParticipantID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            this.m_aSenderID = iParticipantIdentifier;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE receiverParticipantID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            this.m_aReceiverID = iParticipantIdentifier;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE documentTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
            this.m_aDocTypeID = iDocumentTypeIdentifier;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.action(iDocumentTypeIdentifier == null ? null : iDocumentTypeIdentifier.getURIEncoded()));
        }

        @Nonnull
        public final IMPLTYPE processID(@Nullable IProcessIdentifier iProcessIdentifier) {
            this.m_aProcessID = iProcessIdentifier;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.service(iProcessIdentifier == null ? null : iProcessIdentifier.getScheme(), iProcessIdentifier == null ? null : iProcessIdentifier.getValue()));
        }

        @Nonnull
        public final IMPLTYPE fromPartyID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)((AbstractCEFUserMessageBuilder)this.fromPartyIDType(iParticipantIdentifier == null ? null : iParticipantIdentifier.getScheme())).fromPartyID(iParticipantIdentifier == null ? null : iParticipantIdentifier.getValue()));
        }

        @Nonnull
        public final IMPLTYPE toPartyID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)((AbstractCEFUserMessageBuilder)this.toPartyIDType(iParticipantIdentifier == null ? null : iParticipantIdentifier.getScheme())).toPartyID(iParticipantIdentifier == null ? null : iParticipantIdentifier.getValue()));
        }

        @Nonnull
        public final IMPLTYPE endpointDetailProvider(@Nullable IPhase4CEFEndpointDetailProvider iPhase4CEFEndpointDetailProvider) {
            this.m_aEndpointDetailProvider = iPhase4CEFEndpointDetailProvider;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE smpClient(@Nonnull IBDXRServiceMetadataProvider iBDXRServiceMetadataProvider) {
            return this.endpointDetailProvider(new Phase4CEFEndpointDetailProviderBDXR(iBDXRServiceMetadataProvider));
        }

        @Nonnull
        public final IMPLTYPE receiverEndpointDetails(@Nonnull X509Certificate x509Certificate, @Nonnull @Nonempty String string) {
            return this.endpointDetailProvider(new Phase4CEFEndpointDetailProviderConstant(x509Certificate, string));
        }

        @Nonnull
        public final IMPLTYPE certificateConsumer(@Nullable Consumer<X509Certificate> consumer) {
            this.m_aCertificateConsumer = consumer;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE endointURLConsumer(@Nullable Consumer<String> consumer) {
            this.m_aAPEndointURLConsumer = consumer;
            return (IMPLTYPE)((AbstractCEFUserMessageBuilder)this.thisAsT());
        }

        protected final boolean isEndpointDetailProviderUsable() {
            if (this.m_aReceiverID == null) {
                return false;
            }
            if (this.m_aDocTypeID == null) {
                return false;
            }
            if (this.m_aProcessID == null) {
                return false;
            }
            return this.m_aEndpointDetailProvider != null;
        }

        @Override
        protected ESuccess finishFields() throws Phase4Exception {
            if (!this.isEndpointDetailProviderUsable()) {
                LOGGER.error("At least one mandatory field for endpoint discovery is not set and therefore the AS4 message cannot be send.");
                return ESuccess.FAILURE;
            }
            this.m_aEndpointDetailProvider.init(this.m_aDocTypeID, this.m_aProcessID, this.m_aReceiverID);
            X509Certificate x509Certificate = this.m_aEndpointDetailProvider.getReceiverAPCertificate();
            if (this.m_aCertificateConsumer != null) {
                this.m_aCertificateConsumer.accept(x509Certificate);
            }
            this.receiverCertificate(x509Certificate);
            String string = this.m_aEndpointDetailProvider.getReceiverAPEndpointURL();
            if (this.m_aAPEndointURLConsumer != null) {
                this.m_aAPEndointURLConsumer.accept(string);
            }
            this.endpointURL(string);
            return ESuccess.SUCCESS;
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        public boolean isEveryRequiredFieldSet() {
            if (!super.isEveryRequiredFieldSet()) {
                return false;
            }
            if (this.m_aSenderID == null) {
                return false;
            }
            if (this.m_aReceiverID == null) {
                return false;
            }
            if (this.m_aDocTypeID == null) {
                return false;
            }
            if (this.m_aProcessID == null) {
                return false;
            }
            return this.m_aEndpointDetailProvider != null;
        }

        @Override
        protected void customizeBeforeSending() throws Phase4Exception {
            this.addMessageProperty(MessageProperty.builder().name("originalSender").type(this.m_aSenderID.getScheme()).value(this.m_aSenderID.getValue()));
            this.addMessageProperty(MessageProperty.builder().name("finalRecipient").type(this.m_aReceiverID.getScheme()).value(this.m_aReceiverID.getValue()));
        }
    }
}

