/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4ClientSignalMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4PullRequestMessage;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Document;

public class AS4ClientPullRequestMessage
extends AbstractAS4ClientSignalMessage<AS4ClientPullRequestMessage> {
    private String m_sMPC;

    public AS4ClientPullRequestMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(aS4ResourceHelper);
    }

    @Nullable
    public final String getMPC() {
        return this.m_sMPC;
    }

    @Nonnull
    public final AS4ClientPullRequestMessage setMPC(@Nullable String string) {
        this.m_sMPC = string;
        return this;
    }

    private void _checkMandatoryAttributes() {
        if (this.getSoapVersion() == null) {
            throw new IllegalStateException("A SOAP version must be set.");
        }
        if (StringHelper.hasNoText(this.m_sMPC)) {
            throw new IllegalStateException("A MPC has to be present");
        }
    }

    @Override
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws WSSecurityException {
        this._checkMandatoryAttributes();
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, this.getRefToMessageID());
        AS4PullRequestMessage aS4PullRequestMessage = AS4PullRequestMessage.create(this.getSoapVersion(), ebms3MessageInfo, this.m_sMPC, (List)this.any().getClone());
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4PullRequestMessage);
        }
        Document document = aS4PullRequestMessage.getAsSoapDocument();
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document);
        }
        Document document2 = document;
        if (this.signingParams().isSigningEnabled()) {
            IAS4CryptoFactory iAS4CryptoFactory = this.internalCreateCryptoFactory();
            Document document3 = AS4Signer.createSignedMessage(iAS4CryptoFactory, document2, this.getSoapVersion(), aS4PullRequestMessage.getMessagingID(), null, this.getAS4ResourceHelper(), true, this.signingParams().getClone());
            if (iAS4ClientBuildMessageCallback != null) {
                iAS4ClientBuildMessageCallback.onSignedSoapDocument(document3);
            }
            document2 = document3;
        }
        return new AS4ClientBuiltMessage(string, new HttpXMLEntity(document2, this.getSoapVersion().getMimeType()));
    }
}

