/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.annotation.Nonempty;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4ClientSignalMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4ReceiptMessage;
import com.helger.phase4.util.AS4ResourceHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AS4ClientReceiptMessage
extends AbstractAS4ClientSignalMessage<AS4ClientReceiptMessage> {
    private boolean m_bNonRepudiation = false;
    private Node m_aSoapDocument;
    private Ebms3UserMessage m_aEbms3UserMessage;
    private boolean m_bReceiptShouldBeSigned = false;

    public AS4ClientReceiptMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(aS4ResourceHelper);
    }

    public final boolean isNonRepudiation() {
        return this.m_bNonRepudiation;
    }

    @Nonnull
    public final AS4ClientReceiptMessage setNonRepudiation(boolean bl) {
        this.m_bNonRepudiation = bl;
        return this;
    }

    @Nullable
    public final Node getSoapDocument() {
        return this.m_aSoapDocument;
    }

    @Nonnull
    public final AS4ClientReceiptMessage setSoapDocument(@Nullable Node node) {
        this.m_aSoapDocument = node;
        return this;
    }

    @Nullable
    public final Ebms3UserMessage getEbms3UserMessage() {
        return this.m_aEbms3UserMessage;
    }

    @Nonnull
    public final AS4ClientReceiptMessage setEbms3UserMessage(@Nullable Ebms3UserMessage ebms3UserMessage) {
        this.m_aEbms3UserMessage = ebms3UserMessage;
        return this;
    }

    public final boolean isReceiptShouldBeSigned() {
        return this.m_bReceiptShouldBeSigned;
    }

    @Nonnull
    public final AS4ClientReceiptMessage setReceiptShouldBeSigned(boolean bl) {
        this.m_bReceiptShouldBeSigned = bl;
        return this;
    }

    private void _checkMandatoryAttributes() {
        if (this.getSoapVersion() == null) {
            throw new IllegalStateException("A SOAP version must be set.");
        }
        if (this.m_aSoapDocument == null && this.m_aEbms3UserMessage == null) {
            throw new IllegalStateException("A SOAP document or a Ebms3UserMessage has to be set.");
        }
        if (this.m_bNonRepudiation) {
            if (this.m_aSoapDocument == null) {
                throw new IllegalStateException("Nonrepudiation only works in conjunction with a set SOAP document.");
            }
        } else if (this.m_aEbms3UserMessage == null) {
            throw new IllegalStateException("Ebms3UserMessage has to be set, if the SOAP document is not signed.");
        }
    }

    @Override
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws WSSecurityException {
        this._checkMandatoryAttributes();
        AS4ReceiptMessage aS4ReceiptMessage = AS4ReceiptMessage.create(this.getSoapVersion(), string, this.m_aEbms3UserMessage, this.m_aSoapDocument, this.m_bNonRepudiation);
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4ReceiptMessage);
        }
        Document document = aS4ReceiptMessage.getAsSoapDocument();
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document);
        }
        Document document2 = document;
        if (this.m_bReceiptShouldBeSigned && this.signingParams().isSigningEnabled()) {
            IAS4CryptoFactory iAS4CryptoFactory = this.internalCreateCryptoFactory();
            Document document3 = AS4Signer.createSignedMessage(iAS4CryptoFactory, document2, this.getSoapVersion(), aS4ReceiptMessage.getMessagingID(), null, this.getAS4ResourceHelper(), true, this.signingParams().getClone());
            if (iAS4ClientBuildMessageCallback != null) {
                iAS4ClientBuildMessageCallback.onSignedSoapDocument(document3);
            }
            document2 = document3;
        }
        return new AS4ClientBuiltMessage(string, new HttpXMLEntity(document2, this.getSoapVersion().getMimeType()));
    }
}

