/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.mgr.MetaAS4Manager;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4ClientSentMessage<T> {
    private final AS4ClientBuiltMessage m_aBuiltMsg;
    private final T m_aResponse;
    private final LocalDateTime m_aSentDateTime;

    public AS4ClientSentMessage(@Nonnull AS4ClientBuiltMessage aS4ClientBuiltMessage, @Nullable T t) {
        this(aS4ClientBuiltMessage, t, MetaAS4Manager.getTimestampMgr().getCurrentDateTime());
    }

    protected AS4ClientSentMessage(@Nonnull AS4ClientBuiltMessage aS4ClientBuiltMessage, @Nullable T t, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(aS4ClientBuiltMessage, "BuiltMsg");
        ValueEnforcer.notNull(localDateTime, "SentDateTime");
        this.m_aBuiltMsg = aS4ClientBuiltMessage;
        this.m_aResponse = t;
        this.m_aSentDateTime = localDateTime;
    }

    @Nonnull
    public final AS4ClientBuiltMessage getBuiltMessage() {
        return this.m_aBuiltMsg;
    }

    @Nonnull
    @Nonempty
    public final String getMessageID() {
        return this.m_aBuiltMsg.getMessageID();
    }

    @Nullable
    public final T getResponse() {
        return this.m_aResponse;
    }

    public final boolean hasResponse() {
        return this.m_aResponse != null;
    }

    @Nonnull
    public final LocalDateTime getSentDateTime() {
        return this.m_aSentDateTime;
    }

    public String toString() {
        return new ToStringGenerator(this).append("BuiltMsg", this.m_aBuiltMsg).append("Response", this.m_aResponse).append("SentDateTime", this.m_aSentDateTime).getToString();
    }
}

