/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.httpclient.response.ResponseHandlerMicroDom;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.http.BasicHttpPoster;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.mail.MessagingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.wss4j.common.ext.WSSecurityException;

public abstract class AbstractAS4Client<IMPLTYPE extends AbstractAS4Client<IMPLTYPE>>
extends BasicHttpPoster
implements IGenericImplTrait<IMPLTYPE> {
    public static final int DEFAULT_MAX_RETRIES = 0;
    public static final long DEFAULT_RETRY_INTERVAL_MS = 12000L;
    private final AS4ResourceHelper m_aResHelper;
    private IAS4CryptoFactory m_aCryptoFactory;
    private final AS4SigningParams m_aSigningParams = new AS4SigningParams();
    private final AS4CryptParams m_aCryptParams = new AS4CryptParams();
    private ISupplier<String> m_aMessageIDFactory = AbstractAS4Client.createDefaultMessageIDFactory();
    private String m_sRefToMessageID;
    private ESoapVersion m_eSoapVersion = ESoapVersion.AS4_DEFAULT;
    private int m_nMaxRetries = 0;
    private long m_nRetryIntervalMS = 12000L;

    @Nonnull
    public static ISupplier<String> createDefaultMessageIDFactory() {
        return MessageHelperMethods::createRandomMessageID;
    }

    protected AbstractAS4Client(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        this.m_aResHelper = aS4ResourceHelper;
    }

    @Nonnull
    public final AS4ResourceHelper getAS4ResourceHelper() {
        return this.m_aResHelper;
    }

    @Nullable
    public final IAS4CryptoFactory getAS4CryptoFactory() {
        return this.m_aCryptoFactory;
    }

    @Nonnull
    public final IMPLTYPE setAS4CryptoFactory(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.m_aCryptoFactory = iAS4CryptoFactory;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4SigningParams signingParams() {
        return this.m_aSigningParams;
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4CryptParams cryptParams() {
        return this.m_aCryptParams;
    }

    @Nonnull
    public final ISupplier<String> getMessageIDFactory() {
        return this.m_aMessageIDFactory;
    }

    @Nonnull
    public final IMPLTYPE setMessageID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "MessageID");
        return this.setMessageIDFactory(() -> string);
    }

    @Nonnull
    public final IMPLTYPE setMessageIDFactory(@Nonnull ISupplier<String> iSupplier) {
        ValueEnforcer.notNull(iSupplier, "MessageIDFactory");
        this.m_aMessageIDFactory = iSupplier;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    @Nonempty
    public final String createMessageID() {
        String string = (String)this.m_aMessageIDFactory.get();
        if (StringHelper.hasNoText(string)) {
            throw new IllegalStateException("The contained MessageID factory created an empty MessageID!");
        }
        return string;
    }

    @Nullable
    public final String getRefToMessageID() {
        return this.m_sRefToMessageID;
    }

    public final boolean hasRefToMessageID() {
        return StringHelper.hasText(this.m_sRefToMessageID);
    }

    @Nonnull
    public final IMPLTYPE setRefToMessageID(@Nullable String string) {
        this.m_sRefToMessageID = string;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Nonnull
    public final IMPLTYPE setSoapVersion(@Nonnull ESoapVersion eSoapVersion) {
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        this.m_eSoapVersion = eSoapVersion;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnegative
    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final IMPLTYPE setMaxRetries(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "MaxRetries");
        this.m_nMaxRetries = n;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnegative
    public final long getRetryIntervalMS() {
        return this.m_nRetryIntervalMS;
    }

    @Nonnull
    public final IMPLTYPE setRetryIntervalMS(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "RetryIntervalMS");
        this.m_nRetryIntervalMS = l;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    protected IAS4CryptoFactory internalCreateCryptoFactory() {
        if (this.m_aCryptoFactory == null) {
            throw new IllegalStateException("No CryptoFactory is configured.");
        }
        return this.m_aCryptoFactory;
    }

    public final void setValuesFromPMode(@Nullable IPMode iPMode, @Nullable PModeLeg pModeLeg) {
        if (iPMode != null) {
            PModeReceptionAwareness pModeReceptionAwareness = iPMode.getReceptionAwareness();
            if (pModeReceptionAwareness != null && pModeReceptionAwareness.isRetryDefined()) {
                this.setMaxRetries(pModeReceptionAwareness.getMaxRetries());
                this.setRetryIntervalMS(pModeReceptionAwareness.getRetryIntervalMS());
            } else {
                this.setMaxRetries(0);
            }
        }
        if (pModeLeg != null) {
            this.signingParams().setFromPMode(pModeLeg.getSecurity());
            this.cryptParams().setFromPMode(pModeLeg.getSecurity());
        }
    }

    @Nonnull
    public abstract AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String var1, @Nullable IAS4ClientBuildMessageCallback var2) throws IOException, WSSecurityException, MessagingException;

    @Nonnull
    public final <T> AS4ClientSentMessage<T> sendMessageWithRetries(@Nonnull String string, @Nonnull ResponseHandler<? extends T> responseHandler, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback) throws IOException, WSSecurityException, MessagingException {
        String string2 = this.createMessageID();
        AS4ClientBuiltMessage aS4ClientBuiltMessage = this.buildMessage(string2, iAS4ClientBuildMessageCallback);
        HttpEntity httpEntity = aS4ClientBuiltMessage.getHttpEntity();
        HttpHeaderMap httpHeaderMap = aS4ClientBuiltMessage.getCustomHeaders();
        if (this.m_nMaxRetries > 0) {
            httpEntity = this.m_aResHelper.createRepeatableHttpEntity(httpEntity);
        }
        T t = super.sendGenericMessageWithRetries(httpHeaderMap, httpEntity, string2, string, this.m_nMaxRetries, this.m_nRetryIntervalMS, responseHandler, iAS4OutgoingDumper, iAS4RetryCallback);
        return new AS4ClientSentMessage<T>(aS4ClientBuiltMessage, t);
    }

    @Nullable
    public IMicroDocument sendMessageAndGetMicroDocument(@Nonnull String string) throws WSSecurityException, IOException, MessagingException {
        IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback = null;
        IAS4OutgoingDumper iAS4OutgoingDumper = null;
        IAS4RetryCallback iAS4RetryCallback = null;
        IMicroDocument iMicroDocument = this.sendMessageWithRetries(string, new ResponseHandlerMicroDom(), iAS4ClientBuildMessageCallback, iAS4OutgoingDumper, iAS4RetryCallback).getResponse();
        AS4HttpDebug.debug(() -> "SEND-RESPONSE received: " + MicroWriter.getNodeAsString(iMicroDocument, AS4HttpDebug.getDebugXMLWriterSettings()));
        return iMicroDocument;
    }
}

