/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import java.io.Serializable;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AS4CryptParams
implements Serializable,
ICloneable<AS4CryptParams> {
    public static final String DEFAULT_KEY_ENC_ALGORITHM = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    public static final String DEFAULT_MGF_ALGORITHM = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    public static final String DEFAULT_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4CryptParams.class);
    private ECryptoAlgorithmCrypt m_eAlgorithmCrypt;
    private String m_sKeyEncAlgorithm = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    private String m_sMGFAlgorithm = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    private String m_sDigestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    private X509Certificate m_aCert;
    private String m_sAlias;

    public boolean isCryptEnabled(@Nullable Consumer<String> consumer) {
        if (this.m_eAlgorithmCrypt == null) {
            return false;
        }
        if (!this.hasCertificate() && !this.hasAlias()) {
            if (consumer != null) {
                consumer.accept("Crypt parameters have an algorithm defined but neither an alias nor a certificate was provided. Therefore encryption is not enabled.");
            }
            return false;
        }
        return true;
    }

    @Nullable
    public final ECryptoAlgorithmCrypt getAlgorithmCrypt() {
        return this.m_eAlgorithmCrypt;
    }

    @Nonnull
    public final AS4CryptParams setAlgorithmCrypt(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        this.m_eAlgorithmCrypt = eCryptoAlgorithmCrypt;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getKeyEncAlgorithm() {
        return this.m_sKeyEncAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setKeyEncAlgorithm(@Nonnull @Nonempty String string) {
        this.m_sKeyEncAlgorithm = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getMGFAlgorithm() {
        return this.m_sMGFAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setMGFAlgorithm(@Nonnull @Nonempty String string) {
        this.m_sMGFAlgorithm = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getDigestAlgorithm() {
        return this.m_sDigestAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setDigestAlgorithm(@Nonnull @Nonempty String string) {
        this.m_sDigestAlgorithm = string;
        return this;
    }

    @Nullable
    public final X509Certificate getCertificate() {
        return this.m_aCert;
    }

    public final boolean hasCertificate() {
        return this.m_aCert != null;
    }

    @Nonnull
    public final AS4CryptParams setCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aCert = x509Certificate;
        if (x509Certificate != null) {
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                LOGGER.warn("The provided certificate is already expired. Please use a different one.");
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                LOGGER.warn("The provided certificate is not yet valid. Please use a different one.");
            }
        }
        return this;
    }

    @Nullable
    public final String getAlias() {
        return this.m_sAlias;
    }

    public final boolean hasAlias() {
        return StringHelper.hasText(this.m_sAlias);
    }

    @Nonnull
    public final AS4CryptParams setAlias(@Nullable String string) {
        this.m_sAlias = string;
        return this;
    }

    @Nonnull
    public final AS4CryptParams setFromPMode(@Nullable PModeLegSecurity pModeLegSecurity) {
        if (pModeLegSecurity == null) {
            this.setAlgorithmCrypt(null);
        } else {
            this.setAlgorithmCrypt(pModeLegSecurity.getX509EncryptionAlgorithm());
        }
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public AS4CryptParams getClone() {
        return new AS4CryptParams().setAlgorithmCrypt(this.m_eAlgorithmCrypt).setKeyEncAlgorithm(this.m_sKeyEncAlgorithm).setMGFAlgorithm(this.m_sMGFAlgorithm).setDigestAlgorithm(this.m_sDigestAlgorithm).setCertificate(this.m_aCert).setAlias(this.m_sAlias);
    }

    public String toString() {
        return new ToStringGenerator(null).append("AlgorithmCrypt", this.m_eAlgorithmCrypt).append("KeyEncAlgorithm", this.m_sKeyEncAlgorithm).append("MGFAlgorithm", this.m_sMGFAlgorithm).append("DigestAlgorithm", this.m_sDigestAlgorithm).append("Certificate", this.m_aCert).append("Alias", this.m_sAlias).getToString();
    }

    @Nonnull
    @ReturnsMutableObject
    public static AS4CryptParams createDefault() {
        return new AS4CryptParams().setAlgorithmCrypt(ECryptoAlgorithmCrypt.ENCRPYTION_ALGORITHM_DEFAULT);
    }
}

