/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AS4SigningParams
implements Serializable,
ICloneable<AS4SigningParams> {
    private ECryptoAlgorithmSign m_eAlgorithmSign;
    private ECryptoAlgorithmSignDigest m_eAlgorithmSignDigest;

    public boolean isSigningEnabled() {
        return this.m_eAlgorithmSign != null && this.m_eAlgorithmSignDigest != null;
    }

    @Nullable
    public final ECryptoAlgorithmSign getAlgorithmSign() {
        return this.m_eAlgorithmSign;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSign(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_eAlgorithmSign = eCryptoAlgorithmSign;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmSignDigest getAlgorithmSignDigest() {
        return this.m_eAlgorithmSignDigest;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSignDigest(@Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        this.m_eAlgorithmSignDigest = eCryptoAlgorithmSignDigest;
        return this;
    }

    @Nonnull
    public final AS4SigningParams setFromPMode(@Nullable PModeLegSecurity pModeLegSecurity) {
        if (pModeLegSecurity == null) {
            this.setAlgorithmSign(null);
            this.setAlgorithmSignDigest(null);
        } else {
            this.setAlgorithmSign(pModeLegSecurity.getX509SignatureAlgorithm());
            this.setAlgorithmSignDigest(pModeLegSecurity.getX509SignatureHashFunction());
        }
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public AS4SigningParams getClone() {
        return new AS4SigningParams().setAlgorithmSign(this.m_eAlgorithmSign).setAlgorithmSignDigest(this.m_eAlgorithmSignDigest);
    }

    public String toString() {
        return new ToStringGenerator(null).append("AlgorithmSign", this.m_eAlgorithmSign).append("AlgorithmSignDigest", this.m_eAlgorithmSignDigest).getToString();
    }

    @Nonnull
    @ReturnsMutableObject
    public static AS4SigningParams createDefault() {
        return new AS4SigningParams().setAlgorithmSign(ECryptoAlgorithmSign.SIGN_ALGORITHM_DEFAULT).setAlgorithmSignDigest(ECryptoAlgorithmSignDigest.SIGN_DIGEST_ALGORITHM_DEFAULT);
    }
}

