/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;

public enum ECryptoAlgorithmCrypt implements IHasID<String>
{
    CRYPT_3DES("3des", CMSAlgorithm.DES_EDE3_CBC, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"),
    AES_128_CBC("aes128-cbc", CMSAlgorithm.AES128_CBC, "http://www.w3.org/2001/04/xmlenc#aes128-cbc"),
    AES_128_GCM("aes128-gcm", CMSAlgorithm.AES128_GCM, "http://www.w3.org/2009/xmlenc11#aes128-gcm"),
    AES_192_CBC("aes192-cbc", CMSAlgorithm.AES192_CBC, "http://www.w3.org/2001/04/xmlenc#aes192-cbc"),
    AES_192_GCM("aes192-gcm", CMSAlgorithm.AES192_GCM, "http://www.w3.org/2009/xmlenc11#aes192-gcm"),
    AES_256_CBC("aes256-cbc", CMSAlgorithm.AES256_CBC, "http://www.w3.org/2001/04/xmlenc#aes256-cbc"),
    AES_256_GCM("aes256-gcm", CMSAlgorithm.AES256_GCM, "http://www.w3.org/2009/xmlenc11#aes256-gcm");

    public static final ECryptoAlgorithmCrypt ENCRPYTION_ALGORITHM_DEFAULT;
    private final String m_sID;
    private final ASN1ObjectIdentifier m_aOID;
    private final String m_sAlgorithmURI;

    private ECryptoAlgorithmCrypt(@Nonnull @Nonempty String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string3) {
        this.m_sID = string2;
        this.m_aOID = aSN1ObjectIdentifier;
        this.m_sAlgorithmURI = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public ASN1ObjectIdentifier getOID() {
        return this.m_aOID;
    }

    @Nonnull
    @Nonempty
    public String getAlgorithmURI() {
        return this.m_sAlgorithmURI;
    }

    @Nullable
    public static ECryptoAlgorithmCrypt getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ECryptoAlgorithmCrypt.class, string);
    }

    @Nonnull
    public static ECryptoAlgorithmCrypt getFromIDOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDOrThrow(ECryptoAlgorithmCrypt.class, string);
    }

    @Nullable
    public static ECryptoAlgorithmCrypt getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        return EnumHelper.getFromIDOrDefault(ECryptoAlgorithmCrypt.class, string, eCryptoAlgorithmCrypt);
    }

    static {
        ENCRPYTION_ALGORITHM_DEFAULT = AES_128_GCM;
    }
}

