/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECryptoAlgorithmSign implements IHasID<String>
{
    RSA_SHA_256("rsa-sha-256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"),
    RSA_SHA_384("rsa-sha-384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"),
    RSA_SHA_512("rsa-sha-512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");

    public static final ECryptoAlgorithmSign SIGN_ALGORITHM_DEFAULT;
    private final String m_sID;
    private final String m_sAlgorithmURI;

    private ECryptoAlgorithmSign(String string2, String string3) {
        this.m_sID = string2;
        this.m_sAlgorithmURI = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getAlgorithmURI() {
        return this.m_sAlgorithmURI;
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ECryptoAlgorithmSign.class, string);
    }

    @Nonnull
    public static ECryptoAlgorithmSign getFromIDOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDOrThrow(ECryptoAlgorithmSign.class, string);
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        return EnumHelper.getFromIDOrDefault(ECryptoAlgorithmSign.class, string, eCryptoAlgorithmSign);
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromURIOrNull(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(ECryptoAlgorithmSign.class, eCryptoAlgorithmSign -> eCryptoAlgorithmSign.getAlgorithmURI().equals(string));
    }

    static {
        SIGN_ALGORITHM_DEFAULT = RSA_SHA_256;
    }
}

