/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AS4DumpManager {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IAS4IncomingDumper s_aIncomingDumper;
    @GuardedBy(value="s_aRWLock")
    private static IAS4OutgoingDumper s_aOutgoingDumper;

    private AS4DumpManager() {
    }

    @Nullable
    public static IAS4IncomingDumper getIncomingDumper() {
        return s_aRWLock.readLockedGet(() -> s_aIncomingDumper);
    }

    public static void setIncomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        s_aRWLock.writeLockedGet(() -> {
            s_aIncomingDumper = iAS4IncomingDumper;
            return s_aIncomingDumper;
        });
    }

    @Nullable
    public static IAS4OutgoingDumper getOutgoingDumper() {
        return s_aRWLock.readLockedGet(() -> s_aOutgoingDumper);
    }

    public static void setOutgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        s_aRWLock.writeLockedGet(() -> {
            s_aOutgoingDumper = iAS4OutgoingDumper;
            return s_aOutgoingDumper;
        });
    }

    @Nonnull
    public static InputStream getIncomingDumpAwareInputStream(@Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull @WillNotClose InputStream inputStream, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap) throws IOException {
        if (iAS4IncomingDumper == null) {
            return inputStream;
        }
        final OutputStream outputStream = iAS4IncomingDumper.onNewRequest(iAS4IncomingMessageMetadata, httpHeaderMap);
        if (outputStream == null) {
            return inputStream;
        }
        return new WrappedInputStream(inputStream){

            @Override
            public int read() throws IOException {
                int n = super.read();
                if (n != -1) {
                    outputStream.write(n & 0xFF);
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 != -1) {
                    outputStream.write(byArray, n, n3);
                }
                return n3;
            }

            @Override
            public void close() throws IOException {
                try {
                    StreamHelper.flush(outputStream);
                    StreamHelper.close(outputStream);
                }
                finally {
                    super.close();
                }
            }
        };
    }
}

