/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.phase4.dump.AbstractAS4OutgoingDumperWithHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class AS4OutgoingDumperSingleUse
extends AbstractAS4OutgoingDumperWithHeaders {
    private final AtomicBoolean m_aUsedOS = new AtomicBoolean(false);
    private final OutputStream m_aOS;

    public AS4OutgoingDumperSingleUse(@Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(outputStream, "OS");
        this.m_aOS = outputStream;
    }

    @Nonnull
    protected final OutputStream getOutputStream() {
        return this.m_aOS;
    }

    @Override
    protected OutputStream openOutputStream(@Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n) throws IOException {
        if (n > 0) {
            return null;
        }
        if (!this.m_aUsedOS.compareAndSet(false, true)) {
            throw new IllegalStateException("This single-use dumper was already used.");
        }
        return this.m_aOS;
    }
}

