/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.duplicate.AS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import java.time.LocalDateTime;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class AS4DuplicateManagerInMemory
implements IAS4DuplicateManager {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, AS4DuplicateItem> m_aMap = new CommonsHashMap<String, AS4DuplicateItem>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EContinue registerAndCheck(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (StringHelper.hasNoText(string)) {
            return EContinue.CONTINUE;
        }
        AS4DuplicateItem aS4DuplicateItem = new AS4DuplicateItem(string, string2, string3);
        this.m_aRWLock.writeLock().lock();
        try {
            String string4 = aS4DuplicateItem.getID();
            if (this.m_aMap.containsKey(string4)) {
                EContinue eContinue = EContinue.BREAK;
                return eContinue;
            }
            this.m_aMap.put(string4, aS4DuplicateItem);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange clearCache() {
        return this.m_aRWLock.writeLockedGet(this.m_aMap::removeAll);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> evictAllItemsBefore(@Nonnull LocalDateTime localDateTime) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachValue(aS4DuplicateItem -> aS4DuplicateItem.getDateTime().isBefore(localDateTime), aS4DuplicateItem -> commonsArrayList.add(aS4DuplicateItem.getMessageID())));
        if (commonsArrayList.isNotEmpty()) {
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aMap.removeIfKey(commonsArrayList::contains);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return commonsArrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aMap::isEmpty);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    @Nullable
    public IAS4DuplicateItem findFirst(@Nonnull Predicate<? super IAS4DuplicateItem> predicate) {
        return this.m_aRWLock.readLockedGet(() -> (AS4DuplicateItem)CollectionHelper.findFirst(this.m_aMap.values(), predicate));
    }

    @Override
    @Nullable
    public IAS4DuplicateItem getItemOfMessageID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(iAS4DuplicateItem -> iAS4DuplicateItem.getMessageID().equals(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAS4DuplicateItem> getAll() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aMap.values()));
    }
}

