/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.functional.IConsumer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.util.MultiOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpPoster {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHttpPoster.class);
    private HttpClientFactory m_aHttpClientFactory = BasicHttpPoster.createDefaultHttpClientFactory();
    private IConsumer<? super HttpPost> m_aHttpCustomizer;
    private boolean m_bQuoteHttpHeaders = false;

    @Nonnull
    public static HttpClientFactory createDefaultHttpClientFactory() {
        return new HttpClientFactory();
    }

    @Nonnull
    public final HttpClientFactory getHttpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Nonnull
    public final BasicHttpPoster setHttpClientFactory(@Nonnull HttpClientFactory httpClientFactory) {
        ValueEnforcer.notNull(httpClientFactory, "HttpClientFactory");
        this.m_aHttpClientFactory = httpClientFactory;
        return this;
    }

    @Nullable
    public final IConsumer<? super HttpPost> getHttpCustomizer() {
        return this.m_aHttpCustomizer;
    }

    @Nonnull
    public final BasicHttpPoster setHttpCustomizer(@Nullable IConsumer<? super HttpPost> iConsumer) {
        this.m_aHttpCustomizer = iConsumer;
        return this;
    }

    public final boolean isQuoteHttpHeaders() {
        return this.m_bQuoteHttpHeaders;
    }

    @Nonnull
    public final BasicHttpPoster setQuoteHttpHeaders(boolean bl) {
        this.m_bQuoteHttpHeaders = bl;
        return this;
    }

    @Nullable
    public final <T> T sendGenericMessage(@Nonnull @Nonempty String string, @Nonnull HttpEntity httpEntity, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull ResponseHandler<? extends T> responseHandler) throws IOException {
        ValueEnforcer.notEmpty(string, "URL");
        ValueEnforcer.notNull(httpEntity, "HttpEntity");
        try (HttpClientManager httpClientManager = new HttpClientManager(this.m_aHttpClientFactory);){
            HttpPost httpPost = new HttpPost(string);
            if (httpHeaderMap != null) {
                httpHeaderMap.forEachSingleHeader(httpPost::addHeader, true, this.m_bQuoteHttpHeaders);
            }
            httpPost.setEntity(httpEntity);
            if (this.m_aHttpCustomizer != null) {
                this.m_aHttpCustomizer.accept(httpPost);
            }
            AS4HttpDebug.debug(() -> {
                StringBuilder stringBuilder = new StringBuilder("SEND-START to ").append(string).append("\n");
                try {
                    for (Header header : httpPost.getAllHeaders()) {
                        stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
                    }
                    stringBuilder.append("\r\n");
                    if (httpEntity.isRepeatable()) {
                        stringBuilder.append(EntityUtils.toString(httpEntity));
                    } else {
                        stringBuilder.append("## The payload is marked as 'not repeatable' and is the therefore not printed in debugging");
                    }
                }
                catch (Exception exception) {
                    stringBuilder.append("## Exception listing payload: " + exception.getClass().getName() + " -- " + exception.getMessage()).append("\r\n");
                    stringBuilder.append("## ").append(StackTraceHelper.getStackAsString(exception));
                }
                return stringBuilder.toString();
            });
            T t = httpClientManager.execute((HttpUriRequest)httpPost, responseHandler);
            return t;
        }
    }

    @Nonnull
    private static HttpEntity _createDumpingHttpEntity(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nonnull HttpEntity httpEntity, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n, @Nonnull Wrapper<OutputStream> wrapper) throws IOException {
        if (iAS4OutgoingDumper == null) {
            return httpEntity;
        }
        final OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(string, httpHeaderMap, n);
        if (outputStream == null) {
            return httpEntity;
        }
        if (!httpEntity.isRepeatable()) {
            throw new IllegalStateException("This should only be called for repeatable entities");
        }
        wrapper.set(outputStream);
        return new HttpEntityWrapper(httpEntity){

            @Override
            public void writeTo(@Nonnull @WillNotClose OutputStream outputStream2) throws IOException {
                MultiOutputStream multiOutputStream = new MultiOutputStream(outputStream2, outputStream);
                super.writeTo(multiOutputStream);
                multiOutputStream.flush();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public final <T> T sendGenericMessageWithRetries(@Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull String string, @Nonnull String string2, int n, long l, @Nonnull ResponseHandler<? extends T> responseHandler, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback) throws IOException {
        T t;
        IAS4OutgoingDumper iAS4OutgoingDumper2 = iAS4OutgoingDumper != null ? iAS4OutgoingDumper : AS4DumpManager.getOutgoingDumper();
        Wrapper<OutputStream> wrapper = new Wrapper<OutputStream>();
        if (n > 0) {
            if (!httpEntity.isRepeatable()) {
                throw new IllegalStateException("If retry is enabled, a repeatable entity must be provided");
            }
            int n2 = 1 + n;
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    LOGGER.info("Retry #" + n3 + "/" + n + " for sending message with ID '" + string + "'");
                }
                try {
                    HttpEntity httpEntity2 = BasicHttpPoster._createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string, httpHeaderMap, n3, wrapper);
                    T t2 = this.sendGenericMessage(string2, httpEntity2, httpHeaderMap, responseHandler);
                    return t2;
                }
                catch (IOException iOException) {
                    if (n3 == n2 - 1) {
                        throw iOException;
                    }
                    if (iAS4RetryCallback != null && iAS4RetryCallback.onBeforeRetry(string, string2, n3, n2, l, iOException).isBreak()) {
                        LOGGER.warn("Error sending message '" + string + "' to '" + string2 + ": " + iOException.getClass().getSimpleName() + " - " + iOException.getMessage() + " - retrying was explicitly stopped by the RetryCallback");
                        throw iOException;
                    }
                    LOGGER.warn("Error sending message '" + string + "' to '" + string2 + "': " + iOException.getClass().getSimpleName() + " - " + iOException.getMessage() + " - waiting " + l + " ms, than retrying");
                    ThreadHelper.sleep(l);
                    ++n3;
                }
            }
            throw new IllegalStateException("Should never be reached (after maximum of " + n2 + " tries)!");
            finally {
                StreamHelper.flush(wrapper.get());
                StreamHelper.close(wrapper.get());
            }
        }
        HttpEntity httpEntity3 = BasicHttpPoster._createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string, httpHeaderMap, 0, wrapper);
        try {
            t = this.sendGenericMessage(string2, httpEntity3, httpHeaderMap, responseHandler);
        }
        catch (Throwable throwable) {
            StreamHelper.flush(wrapper.get());
            StreamHelper.close(wrapper.get());
            throw throwable;
        }
        StreamHelper.flush(wrapper.get());
        StreamHelper.close(wrapper.get());
        return t;
        finally {
            if (iAS4OutgoingDumper2 != null) {
                try {
                    iAS4OutgoingDumper2.onEndRequest(string);
                }
                catch (Exception exception) {
                    LOGGER.error("OutgoingDumper.onEndRequest failed. Dumper=" + iAS4OutgoingDumper2 + "; MessageID=" + string, exception);
                }
            }
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("HttpClientFactory", this.m_aHttpClientFactory).append("HttpCustomizer", this.m_aHttpCustomizer).append("QuoteHttpHeaders", this.m_bQuoteHttpHeaders).getToString();
    }
}

