/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.Cookie;

@Immutable
public final class AS4MessagingHelper {
    private AS4MessagingHelper() {
    }

    @Nonnull
    @Nonempty
    public static IJsonObject getIncomingMetadataAsJson(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("IncomingUniqueID", iAS4IncomingMessageMetadata.getIncomingUniqueID());
        jsonObject.add("IncomingDT", PDTWebDateHelper.getAsStringXSD(iAS4IncomingMessageMetadata.getIncomingDT()));
        jsonObject.add("Mode", iAS4IncomingMessageMetadata.getMode().getID());
        if (iAS4IncomingMessageMetadata.hasRemoteAddr()) {
            jsonObject.add("RemoteAddr", iAS4IncomingMessageMetadata.getRemoteAddr());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteHost()) {
            jsonObject.add("RemoteHost", iAS4IncomingMessageMetadata.getRemoteHost());
        }
        if (iAS4IncomingMessageMetadata.hasRemotePort()) {
            jsonObject.add("RemotePort", iAS4IncomingMessageMetadata.getRemotePort());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteUser()) {
            jsonObject.add("RemoteUser", iAS4IncomingMessageMetadata.getRemoteUser());
        }
        JsonArray jsonArray = new JsonArray();
        for (Cookie cookie : iAS4IncomingMessageMetadata.cookies()) {
            JsonObject jsonObject2 = new JsonObject();
            if (StringHelper.hasText(cookie.getDomain())) {
                jsonObject2.add("Domain", cookie.getDomain());
            }
            if (StringHelper.hasText(cookie.getPath())) {
                jsonObject2.add("Path", cookie.getPath());
            }
            jsonObject2.add("Secure", cookie.getSecure());
            jsonObject2.add("HttpOnly", cookie.isHttpOnly());
            jsonObject2.add("Name", cookie.getName());
            jsonObject2.add("Value", cookie.getValue());
            jsonObject2.add("Version", cookie.getVersion());
            jsonObject2.add("MaxAge", cookie.getMaxAge());
            if (StringHelper.hasText(cookie.getComment())) {
                jsonObject2.add("Comment", cookie.getComment());
            }
            jsonArray.add(jsonObject2);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject.addJson("Cookies", jsonArray);
        }
        return jsonObject;
    }
}

