/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mime.CMimeType;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.MimeMessageCreator;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.mail.MessagingException;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public final class AS4Encryptor {
    private AS4Encryptor() {
    }

    @Nonnull
    private static WSSecEncrypt _createEncrypt(@Nonnull WSSecHeader wSSecHeader, @Nonnull AS4CryptParams aS4CryptParams) {
        WSSecEncrypt wSSecEncrypt = new WSSecEncrypt(wSSecHeader);
        wSSecEncrypt.setKeyIdentifierType(1);
        wSSecEncrypt.setSymmetricEncAlgorithm(aS4CryptParams.getAlgorithmCrypt().getAlgorithmURI());
        wSSecEncrypt.setKeyEncAlgo(aS4CryptParams.getKeyEncAlgorithm());
        wSSecEncrypt.setMGFAlgorithm(aS4CryptParams.getMGFAlgorithm());
        wSSecEncrypt.setDigestAlgorithm(aS4CryptParams.getDigestAlgorithm());
        wSSecEncrypt.setEncryptSymmKey(true);
        if (aS4CryptParams.hasCertificate()) {
            wSSecEncrypt.setUseThisCert(aS4CryptParams.getCertificate());
        } else if (aS4CryptParams.hasAlias()) {
            wSSecEncrypt.setUserInfo(aS4CryptParams.getAlias());
        }
        return wSSecEncrypt;
    }

    @Nonnull
    public static Document encryptSoapBodyPayload(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, boolean bl, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        ValueEnforcer.notNull(iAS4CryptoFactory, "CryptoFactory");
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        ValueEnforcer.notNull(document, "XMLDoc");
        ValueEnforcer.notNull(aS4CryptParams, "CryptParams");
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecEncrypt wSSecEncrypt = AS4Encryptor._createEncrypt(wSSecHeader, aS4CryptParams);
        wSSecEncrypt.getParts().add(new WSEncryptionPart("Body", eSoapVersion.getNamespaceURI(), "Content"));
        Attr attr = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
        if (attr != null) {
            attr.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        KeyGenerator keyGenerator = KeyUtils.getKeyGenerator("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey secretKey = keyGenerator.generateKey();
        return wSSecEncrypt.build(iAS4CryptoFactory.getCrypto(), secretKey);
    }

    @Nonnull
    public static AS4MimeMessage encryptMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, boolean bl, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        Attr attr;
        ValueEnforcer.notNull(iAS4CryptoFactory, "CryptoFactory");
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        ValueEnforcer.notNull(document, "XMLDoc");
        ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        ValueEnforcer.notNull(aS4CryptParams, "CryptParams");
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecEncrypt wSSecEncrypt = AS4Encryptor._createEncrypt(wSSecHeader, aS4CryptParams);
        wSSecEncrypt.getParts().add(new WSEncryptionPart(MessageHelperMethods.PREFIX_CID + "Attachments", "Content"));
        WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = null;
        if (CollectionHelper.isNotEmpty(iCommonsList)) {
            wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler(iCommonsList, aS4ResourceHelper);
            wSSecEncrypt.setAttachmentCallbackHandler(wSS4JAttachmentCallbackHandler);
        }
        if ((attr = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand")) != null) {
            attr.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        KeyGenerator keyGenerator = KeyUtils.getKeyGenerator("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey secretKey = keyGenerator.generateKey();
        Document document2 = wSSecEncrypt.build(iAS4CryptoFactory.getCrypto(), secretKey);
        ICommonsList<WSS4JAttachment> iCommonsList2 = null;
        if (wSS4JAttachmentCallbackHandler != null) {
            iCommonsList2 = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
            for (WSS4JAttachment wSS4JAttachment : iCommonsList2) {
                wSS4JAttachment.overwriteMimeType(CMimeType.APPLICATION_OCTET_STREAM.getAsString());
                wSS4JAttachment.setContentTransferEncoding(EContentTransferEncoding.BINARY);
            }
        }
        return MimeMessageCreator.generateMimeMessage(eSoapVersion, document2, iCommonsList2);
    }
}

