/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.w3c.dom.Document;

public final class AS4Signer {
    private AS4Signer() {
    }

    @Nonnull
    public static Document createSignedMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, boolean bl, @Nonnull AS4SigningParams aS4SigningParams) throws WSSecurityException {
        Object object;
        ValueEnforcer.notNull(iAS4CryptoFactory, "CryptoFactory");
        ValueEnforcer.notNull(document, "PreSigningMessage");
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        ValueEnforcer.notEmpty(string, "MessagingID");
        ValueEnforcer.notNull(aS4ResourceHelper, "ResHelper");
        ValueEnforcer.notNull(aS4SigningParams, "SigningParams");
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecSignature wSSecSignature = new WSSecSignature(wSSecHeader);
        wSSecSignature.setKeyIdentifierType(1);
        wSSecSignature.setUserInfo(iAS4CryptoFactory.getKeyAlias(), iAS4CryptoFactory.getKeyPassword());
        wSSecSignature.setSignatureAlgorithm(aS4SigningParams.getAlgorithmSign().getAlgorithmURI());
        wSSecSignature.setDigestAlgo(aS4SigningParams.getAlgorithmSignDigest().getAlgorithmURI());
        wSSecSignature.getParts().add(new WSEncryptionPart(string, "Content"));
        wSSecSignature.getParts().add(new WSEncryptionPart("Body", eSoapVersion.getNamespaceURI(), "Content"));
        if (CollectionHelper.isNotEmpty(iCommonsList)) {
            wSSecSignature.getParts().add(new WSEncryptionPart(MessageHelperMethods.PREFIX_CID + "Attachments", "Content"));
            object = new WSS4JAttachmentCallbackHandler(iCommonsList, aS4ResourceHelper);
            wSSecSignature.setAttachmentCallbackHandler((CallbackHandler)object);
        }
        if ((object = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand")) != null) {
            object.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        return wSSecSignature.build(iAS4CryptoFactory.getCrypto());
    }
}

