/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.ebms3header.MessagePartNRInformation;
import com.helger.phase4.ebms3header.NonRepudiationInformation;
import com.helger.phase4.marshaller.Ebms3WriterBuilder;
import com.helger.phase4.marshaller.XMLDSigReaderBuilder;
import com.helger.phase4.messaging.domain.AS4UserMessage;
import com.helger.phase4.messaging.domain.AbstractAS4Message;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xsds.xmldsig.ReferenceType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AS4ReceiptMessage
extends AbstractAS4Message<AS4ReceiptMessage> {
    private final Ebms3SignalMessage m_aSignalMessage;

    public AS4ReceiptMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3SignalMessage ebms3SignalMessage) {
        super(eSoapVersion, EAS4MessageType.RECEIPT);
        ValueEnforcer.notNull(ebms3SignalMessage, "SignalMessage");
        this.m_aMessaging.addSignalMessage(ebms3SignalMessage);
        this.m_aSignalMessage = ebms3SignalMessage;
    }

    @Nonnull
    public final Ebms3SignalMessage getEbms3SignalMessage() {
        return this.m_aSignalMessage;
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<Node> _getAllReferences(@Nullable Node node) {
        CommonsArrayList<Node> commonsArrayList = new CommonsArrayList<Node>();
        Element element = XMLHelper.getFirstChildElementOfName(node, "Envelope");
        if (element != null && (element = XMLHelper.getFirstChildElementOfName(element, "Header")) != null && (element = XMLHelper.getFirstChildElementOfName(element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security")) != null && (element = XMLHelper.getFirstChildElementOfName(element, "http://www.w3.org/2000/09/xmldsig#", "Signature")) != null && (element = XMLHelper.getFirstChildElementOfName(element, "http://www.w3.org/2000/09/xmldsig#", "SignedInfo")) != null) {
            new ChildElementIterator(element).findAll(XMLHelper.filterElementWithNamespaceAndLocalName("http://www.w3.org/2000/09/xmldsig#", "Reference"), commonsArrayList::add);
        }
        return commonsArrayList;
    }

    @Nonnull
    public static AS4ReceiptMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Node node, @Nonnull boolean bl) {
        ICommonsList<Node> iCommonsList = AS4ReceiptMessage._getAllReferences(node);
        Ebms3SignalMessage ebms3SignalMessage = new Ebms3SignalMessage();
        IExplicitlyCloneable iExplicitlyCloneable = MessageHelperMethods.createEbms3MessageInfo(string, null);
        if (ebms3UserMessage != null) {
            ((Ebms3MessageInfo)iExplicitlyCloneable).setRefToMessageId(ebms3UserMessage.getMessageInfo().getMessageId());
        }
        ebms3SignalMessage.setMessageInfo((Ebms3MessageInfo)iExplicitlyCloneable);
        iExplicitlyCloneable = new Ebms3Receipt();
        if (iCommonsList.isNotEmpty() && bl) {
            NonRepudiationInformation nonRepudiationInformation = new NonRepudiationInformation();
            for (Node node2 : iCommonsList) {
                ReferenceType referenceType = (ReferenceType)XMLDSigReaderBuilder.dsigReference().read(node2);
                MessagePartNRInformation messagePartNRInformation = new MessagePartNRInformation();
                messagePartNRInformation.setReference(referenceType);
                nonRepudiationInformation.addMessagePartNRInformation(messagePartNRInformation);
            }
            ((Ebms3Receipt)iExplicitlyCloneable).addAny(Ebms3WriterBuilder.nonRepudiationInformation().getAsDocument(nonRepudiationInformation).getDocumentElement());
        } else {
            ((Ebms3Receipt)iExplicitlyCloneable).addAny(AS4UserMessage.create(eSoapVersion, ebms3UserMessage).getAsSoapDocument().getDocumentElement());
        }
        ebms3SignalMessage.setReceipt((Ebms3Receipt)iExplicitlyCloneable);
        return new AS4ReceiptMessage(eSoapVersion, ebms3SignalMessage);
    }
}

