/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.DataContentHandlerSoap12;
import com.helger.phase4.messaging.mime.SoapMimeMultipart;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4XMLHelper;
import java.nio.charset.Charset;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;

public final class MimeMessageCreator {
    private MimeMessageCreator() {
    }

    @Nonnull
    public static AS4MimeMessage generateMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws MessagingException {
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        ValueEnforcer.notNull(document, "SoapEnvelope");
        Charset charset = AS4XMLHelper.XWS.getCharset();
        SoapMimeMultipart soapMimeMultipart = new SoapMimeMultipart(eSoapVersion, charset);
        EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.BINARY;
        String string = eSoapVersion.getMimeType(charset).getAsString();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent(new DOMSource(document), string);
        mimeBodyPart.setHeader("Content-Transfer-Encoding", eContentTransferEncoding.getID());
        soapMimeMultipart.addBodyPart(mimeBodyPart);
        boolean bl = true;
        if (iCommonsList != null) {
            for (WSS4JAttachment wSS4JAttachment : iCommonsList) {
                wSS4JAttachment.addToMimeMultipart(soapMimeMultipart);
                if (wSS4JAttachment.isRepeatable()) continue;
                bl = false;
            }
        }
        AS4MimeMessage aS4MimeMessage = new AS4MimeMessage((Session)null, bl);
        aS4MimeMessage.setContent(soapMimeMultipart);
        aS4MimeMessage.saveChanges();
        return aS4MimeMessage;
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap(ESoapVersion.SOAP_12.getMimeType().getAsStringWithoutParameters() + ";; x-java-content-handler=" + DataContentHandlerSoap12.class.getName());
        CommandMap.setDefaultCommandMap(mailcapCommandMap);
    }
}

