/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.phase4.mgr.IAS4TimestampManager;
import com.helger.phase4.mgr.IManagerFactory;
import com.helger.phase4.mgr.ManagerFactoryInMemory;
import com.helger.phase4.mgr.ManagerFactoryPersistingFileSystem;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.profile.AS4ProfileManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaAS4Manager
extends AbstractGlobalSingleton {
    public static final String SYSTEM_PROPERTY_PHASE4_MANAGER_INMEMORY = "phase4.manager.inmemory";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaAS4Manager.class);
    private static IManagerFactory s_aFactory;
    private static IAS4TimestampManager s_aTimestampMgr;
    private IMPCManager m_aMPCMgr;
    private IPModeManager m_aPModeMgr;
    private IAS4DuplicateManager m_aIncomingDuplicateMgr;
    private AS4ProfileManager m_aProfileMgr;

    @Nonnull
    public static IManagerFactory getFactory() {
        return s_aFactory;
    }

    public static void setFactory(@Nonnull IManagerFactory iManagerFactory) {
        ValueEnforcer.notNull(iManagerFactory, "Factory");
        s_aFactory = iManagerFactory;
        s_aTimestampMgr = s_aFactory.createTimestampManager();
    }

    @Deprecated
    @UsedViaReflection
    public MetaAS4Manager() {
    }

    private void _initCallbacks() {
    }

    @Override
    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            this.m_aMPCMgr = s_aFactory.createMPCManager();
            this.m_aPModeMgr = s_aFactory.createPModeManager();
            this.m_aIncomingDuplicateMgr = s_aFactory.createDuplicateManager();
            this.m_aProfileMgr = new AS4ProfileManager();
            this._initCallbacks();
            this.m_aPModeMgr.validateAllPModes();
            LOGGER.info(ClassHelper.getClassLocalName(this) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName(this), exception);
        }
    }

    @Nonnull
    public static MetaAS4Manager getInstance() {
        return MetaAS4Manager.getGlobalSingleton(MetaAS4Manager.class);
    }

    @Nonnull
    public static IMPCManager getMPCMgr() {
        return MetaAS4Manager.getInstance().m_aMPCMgr;
    }

    @Nonnull
    public static IPModeManager getPModeMgr() {
        return MetaAS4Manager.getInstance().m_aPModeMgr;
    }

    @Nonnull
    public static IAS4DuplicateManager getIncomingDuplicateMgr() {
        return MetaAS4Manager.getInstance().m_aIncomingDuplicateMgr;
    }

    @Nonnull
    public static AS4ProfileManager getProfileMgr() {
        return MetaAS4Manager.getInstance().m_aProfileMgr;
    }

    @Nonnull
    public static IAS4TimestampManager getTimestampMgr() {
        return s_aTimestampMgr;
    }

    static {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_PHASE4_MANAGER_INMEMORY);
        if (StringParser.parseBool(string, false)) {
            LOGGER.info("MetaAS4Manager is initialized with in-memory data structures");
            s_aFactory = new ManagerFactoryInMemory();
        } else {
            LOGGER.info("MetaAS4Manager is using file system persistence");
            s_aFactory = new ManagerFactoryPersistingFileSystem();
        }
        s_aTimestampMgr = s_aFactory.createTimestampManager();
    }
}

