/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMEP implements IHasID<String>
{
    ONE_WAY("oneway", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/oneWay"),
    TWO_WAY("twoway", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/twoWay");

    public static final EMEP DEFAULT_EBMS;
    private final String m_sID;
    private final String m_sURI;

    private EMEP(String string2, String string3) {
        this.m_sID = string2;
        this.m_sURI = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnegative
    public int getMessageCount() {
        if (this.isOneWay()) {
            return 1;
        }
        if (this.isTwoWay()) {
            return 2;
        }
        throw new IllegalStateException();
    }

    public boolean isOneWay() {
        return this == ONE_WAY;
    }

    public boolean isTwoWay() {
        return this == TWO_WAY;
    }

    @Nonnull
    @Nonempty
    public String getURI() {
        return this.m_sURI;
    }

    @Nullable
    public static EMEP getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EMEP.class, string);
    }

    @Nullable
    public static EMEP getFromURIOrNull(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EMEP.class, eMEP -> string.equals(eMEP.getURI()));
    }

    static {
        DEFAULT_EBMS = ONE_WAY;
    }
}

