/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model;

import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MEPHelper {
    private MEPHelper() {
    }

    private static boolean _isValidResponseType(@Nonnull EMEP eMEP, @Nonnull EMEPBinding eMEPBinding, @Nonnull EAS4MessageType eAS4MessageType, boolean bl) {
        switch (eMEP) {
            case ONE_WAY: {
                assert (bl);
                switch (eMEPBinding) {
                    case PUSH: {
                        return eAS4MessageType.isReceiptOrError();
                    }
                    case PULL: {
                        return eAS4MessageType.isUserMessage();
                    }
                    case SYNC: 
                    case PUSH_PUSH: 
                    case PUSH_PULL: 
                    case PULL_PUSH: {
                        return false;
                    }
                }
                break;
            }
            case TWO_WAY: {
                switch (eMEPBinding) {
                    case PUSH: {
                        assert (bl);
                        return eAS4MessageType.isReceiptOrError();
                    }
                    case PULL: {
                        assert (bl);
                        return eAS4MessageType.isUserMessage();
                    }
                    case SYNC: {
                        return eAS4MessageType.isUserMessage();
                    }
                    case PUSH_PUSH: {
                        if (bl) {
                            return eAS4MessageType.isReceiptOrError();
                        }
                        return eAS4MessageType.isUserMessage();
                    }
                    case PUSH_PULL: {
                        if (bl) {
                            return eAS4MessageType.isReceiptOrError();
                        }
                        return eAS4MessageType.isUserMessage();
                    }
                    case PULL_PUSH: {
                        if (bl) {
                            return eAS4MessageType.isUserMessage();
                        }
                        return eAS4MessageType.isReceiptOrError();
                    }
                }
            }
        }
        throw new IllegalStateException("Unhandled combination: " + eMEP + "/" + eMEPBinding + "/" + eAS4MessageType);
    }

    public static boolean isValidResponseTypeLeg1(@Nonnull EMEP eMEP, @Nonnull EMEPBinding eMEPBinding, @Nonnull EAS4MessageType eAS4MessageType) {
        return MEPHelper._isValidResponseType(eMEP, eMEPBinding, eAS4MessageType, true);
    }

    public static boolean isValidResponseTypeLeg2(@Nonnull EMEP eMEP, @Nonnull EMEPBinding eMEPBinding, @Nonnull EAS4MessageType eAS4MessageType) {
        return MEPHelper._isValidResponseType(eMEP, eMEPBinding, eAS4MessageType, false);
    }
}

