/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.mpc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EChange;
import com.helger.dao.DAOException;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.mpc.MPC;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MPCManager
extends AbstractPhotonMapBasedWALDAO<IMPC, MPC>
implements IMPCManager {
    public MPCManager(@Nullable String string) throws DAOException {
        super(MPC.class, string);
    }

    @Override
    @Nonnull
    protected EChange onInit() {
        this.createMPC(new MPC("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC"));
        return EChange.CHANGED;
    }

    @Override
    public void createMPC(@Nonnull MPC mPC) {
        ValueEnforcer.notNull(mPC, "MPC");
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(mPC));
        AuditHelper.onAuditCreateSuccess(MPC.OT, mPC.getID());
    }

    @Override
    @Nonnull
    public EChange updateMPC(@Nonnull IMPC iMPC) {
        ValueEnforcer.notNull(iMPC, "MPC");
        MPC mPC = (MPC)this.getOfID((String)iMPC.getID());
        if (mPC == null) {
            AuditHelper.onAuditModifyFailure(MPC.OT, (String)iMPC.getID(), "no-such-id");
            return EChange.UNCHANGED;
        }
        if (mPC.isDeleted()) {
            AuditHelper.onAuditModifyFailure(MPC.OT, (String)iMPC.getID(), "already-deleted");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            BusinessObjectHelper.setLastModificationNow(mPC);
            this.internalUpdateItem(mPC);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(MPC.OT, "all", mPC.getID());
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markMPCDeleted(@Nullable String string) {
        MPC mPC = (MPC)this.getOfID(string);
        if (mPC == null) {
            AuditHelper.onAuditDeleteFailure(MPC.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(mPC).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(MPC.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(mPC);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(MPC.OT, string);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deleteMPC(@Nullable String string) {
        MPC mPC = (MPC)this.getOfID(string);
        if (mPC == null) {
            AuditHelper.onAuditDeleteFailure(MPC.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.internalDeleteItem(string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(MPC.OT, string);
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IMPC getMPCOfID(@Nullable String string) {
        return (IMPC)this.getOfID(string);
    }
}

