/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.mpc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.mpc.MPC;
import com.helger.photon.security.object.BusinessObjectHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MPCManagerInMemory
implements IMPCManager {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, MPC> m_aMap = new CommonsHashMap<String, MPC>();

    public MPCManagerInMemory() {
        this.createMPC(new MPC("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC"));
    }

    @Override
    public final void createMPC(@Nonnull MPC mPC) {
        ValueEnforcer.notNull(mPC, "MPC");
        this.m_aRWLock.writeLocked(() -> {
            String string = mPC.getID();
            if (this.m_aMap.containsKey(string)) {
                throw new IllegalArgumentException("An object with ID '" + string + "' is already contained!");
            }
            this.m_aMap.put(string, mPC);
        });
    }

    @Override
    @Nonnull
    public EChange updateMPC(@Nonnull IMPC iMPC) {
        ValueEnforcer.notNull(iMPC, "MPC");
        MPC mPC = this.getOfID((String)iMPC.getID());
        if (mPC == null || mPC.isDeleted()) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            BusinessObjectHelper.setLastModificationNow(mPC);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markMPCDeleted(@Nullable String string) {
        MPC mPC = this.getOfID(string);
        if (mPC == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(mPC).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deleteMPC(@Nullable String string) {
        MPC mPC = this.getOfID(string);
        if (mPC == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.remove(string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EChange.CHANGED;
    }

    @Nullable
    MPC getOfID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (MPC)this.m_aMap.get(string));
    }

    @Override
    @Nullable
    public IMPC getMPCOfID(@Nullable String string) {
        return this.getOfID(string);
    }

    @Override
    public boolean containsWithID(String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.containsKey(string));
    }
}

