/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.state.EChange;
import com.helger.dao.DAOException;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PModeManager
extends AbstractPhotonMapBasedWALDAO<IPMode, PMode>
implements IPModeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PModeManager.class);

    public PModeManager(@Nullable String string) throws DAOException {
        super(PMode.class, string);
    }

    private void _validatePMode(@Nonnull IPMode iPMode) {
        try {
            this.validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            throw new IllegalArgumentException("PMode is invalid", pModeValidationException);
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _createPModeLocked(@Nonnull PMode pMode) {
        this.internalCreateItem(pMode);
        AuditHelper.onAuditCreateSuccess(PMode.OT, pMode.getID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created PMode with ID '" + pMode.getID() + "'");
        }
    }

    @Override
    public void createPMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull(pMode, "PMode");
        this._validatePMode(pMode);
        this.m_aRWLock.writeLocked(() -> this._createPModeLocked(pMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange updatePMode(@Nonnull IPMode iPMode) {
        ValueEnforcer.notNull(iPMode, "PMode");
        this._validatePMode(iPMode);
        PMode pMode = (PMode)this.getOfID((String)iPMode.getID());
        if (pMode == null) {
            AuditHelper.onAuditModifyFailure(PMode.OT, (String)iPMode.getID(), "no-such-id");
            return EChange.UNCHANGED;
        }
        if (pMode.isDeleted()) {
            AuditHelper.onAuditModifyFailure(PMode.OT, (String)iPMode.getID(), "already-deleted");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(pMode.setInitiator(iPMode.getInitiator()));
            eChange = eChange.or(pMode.setResponder(iPMode.getResponder()));
            eChange = eChange.or(pMode.setAgreement(iPMode.getAgreement()));
            eChange = eChange.or(pMode.setMEP(iPMode.getMEP()));
            eChange = eChange.or(pMode.setMEPBinding(iPMode.getMEPBinding()));
            eChange = eChange.or(pMode.setLeg1(iPMode.getLeg1()));
            eChange = eChange.or(pMode.setLeg2(iPMode.getLeg2()));
            eChange = eChange.or(pMode.setPayloadService(iPMode.getPayloadService()));
            eChange = eChange.or(pMode.setReceptionAwareness(iPMode.getReceptionAwareness()));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(pMode);
            this.internalUpdateItem(pMode);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(PMode.OT, "all", pMode.getID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated PMode with ID '" + (String)iPMode.getID() + "'");
        }
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public void createOrUpdatePMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull(pMode, "PMode");
        this._validatePMode(pMode);
        IPredicate<IPMode> iPredicate = IPModeManager.getPModeFilter(pMode.getID(), pMode.getInitiatorID(), pMode.getResponderID());
        IPMode iPMode = this.findFirst(iPredicate);
        if (iPMode == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                iPMode = this.findFirst(iPredicate);
                if (iPMode == null) {
                    this._createPModeLocked(pMode);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (iPMode != null) {
            this.updatePMode(iPMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markPModeDeleted(@Nullable String string) {
        PMode pMode = (PMode)this.getOfID(string);
        if (pMode == null) {
            AuditHelper.onAuditDeleteFailure(PMode.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(pMode).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(PMode.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(pMode);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(PMode.OT, string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Marked PMode with ID '" + pMode.getID() + "' as deleted");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deletePMode(@Nullable String string) {
        PMode pMode = (PMode)this.getOfID(string);
        if (pMode == null) {
            AuditHelper.onAuditDeleteFailure(PMode.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.internalDeleteItem(string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(PMode.OT, string);
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IPMode getPModeOfID(@Nullable String string) {
        return (IPMode)this.getOfID(string);
    }
}

