/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class PModeParty
implements IHasID<String>,
Serializable {
    private final String m_sIDType;
    private final String m_sIDValue;
    private final String m_sRole;
    private final String m_sUserName;
    private final String m_sPassword;
    private transient String m_sStatusID;

    public PModeParty(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4, @Nullable String string5) {
        this.m_sIDType = string;
        this.m_sIDValue = ValueEnforcer.notEmpty(string2, "IDValue");
        this.m_sRole = ValueEnforcer.notEmpty(string3, "Role");
        this.m_sUserName = string4;
        this.m_sPassword = string5;
    }

    @Nullable
    public String getIDType() {
        return this.m_sIDType;
    }

    public boolean hasIDType() {
        return StringHelper.hasText(this.m_sIDType);
    }

    @Nonnull
    @Nonempty
    public String getIDValue() {
        return this.m_sIDValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        String string = this.m_sStatusID;
        if (string == null) {
            string = StringHelper.hasText(this.m_sIDType) ? this.m_sIDType + ":" + this.m_sIDValue : this.m_sIDValue;
            this.m_sStatusID = string;
        }
        return string;
    }

    @Nonnull
    @Nonempty
    public String getRole() {
        return this.m_sRole;
    }

    @Nullable
    public String getUserName() {
        return this.m_sUserName;
    }

    public boolean hasUserName() {
        return StringHelper.hasText(this.m_sUserName);
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        return StringHelper.hasText(this.m_sPassword);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeParty pModeParty = (PModeParty)object;
        return EqualsHelper.equals(this.m_sIDType, pModeParty.m_sIDType) && this.m_sIDValue.equals(pModeParty.m_sIDValue) && this.m_sRole.equals(pModeParty.m_sRole) && EqualsHelper.equals(this.m_sUserName, pModeParty.m_sUserName) && EqualsHelper.equals(this.m_sPassword, pModeParty.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sIDType).append(this.m_sIDValue).append(this.m_sRole).append(this.m_sUserName).append(this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("IDType", this.m_sIDType).append("IDValue", this.m_sIDValue).append("Role", this.m_sRole).append("UserName", this.m_sUserName).appendPassword("Password").getToString();
    }

    @Nonnull
    public static PModeParty createSimple(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return new PModeParty(null, string, string2, null, null);
    }
}

