/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeReceptionAwareness
implements Serializable {
    public static final boolean DEFAULT_RECEPTION_AWARENESS = true;
    public static final boolean DEFAULT_RETRY = true;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final int DEFAULT_RETRY_INTERVAL_MS = 10000;
    public static final boolean DEFAULT_DUPLICATE_DETECTION = true;
    private ETriState m_eReceptionAwareness;
    private ETriState m_eRetry;
    private int m_nMaxRetries;
    private int m_nRetryIntervalMS;
    private ETriState m_eDuplicateDetection;

    public PModeReceptionAwareness(@Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, int n, int n2, @Nonnull ETriState eTriState3) {
        this.setReceptionAwareness(eTriState);
        this.setRetry(eTriState2);
        this.setMaxRetries(n);
        this.setRetryIntervalMS(n2);
        this.setDuplicateDetection(eTriState3);
    }

    public final boolean isReceptionAwarenessDefined() {
        return this.m_eReceptionAwareness.isDefined();
    }

    public final boolean isReceptionAwareness() {
        return this.m_eReceptionAwareness.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setReceptionAwareness(boolean bl) {
        return this.setReceptionAwareness(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setReceptionAwareness(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "ReceptionAwareness");
        if (eTriState.equals(this.m_eReceptionAwareness)) {
            return EChange.UNCHANGED;
        }
        this.m_eReceptionAwareness = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isRetryDefined() {
        return this.m_eRetry.isDefined();
    }

    public final boolean isRetry() {
        return this.m_eRetry.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setRetry(boolean bl) {
        return this.setRetry(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setRetry(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "Retry");
        if (eTriState.equals(this.m_eRetry)) {
            return EChange.UNCHANGED;
        }
        this.m_eRetry = eTriState;
        return EChange.CHANGED;
    }

    @Nonnegative
    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final EChange setMaxRetries(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "MaxRetries");
        if (n == this.m_nMaxRetries) {
            return EChange.UNCHANGED;
        }
        this.m_nMaxRetries = n;
        return EChange.CHANGED;
    }

    @Nonnegative
    public final int getRetryIntervalMS() {
        return this.m_nRetryIntervalMS;
    }

    @Nonnull
    public final EChange setRetryIntervalMS(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "RetryIntervalMS");
        if (n == this.m_nRetryIntervalMS) {
            return EChange.UNCHANGED;
        }
        this.m_nRetryIntervalMS = n;
        return EChange.CHANGED;
    }

    public final boolean isDuplicateDetectionDefined() {
        return this.m_eDuplicateDetection.isDefined();
    }

    public final boolean isDuplicateDetection() {
        return this.m_eDuplicateDetection.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setDuplicateDetection(boolean bl) {
        return this.setDuplicateDetection(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setDuplicateDetection(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "DuplicateDetection");
        if (eTriState.equals(this.m_eDuplicateDetection)) {
            return EChange.UNCHANGED;
        }
        this.m_eDuplicateDetection = eTriState;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeReceptionAwareness pModeReceptionAwareness = (PModeReceptionAwareness)object;
        return this.m_eReceptionAwareness.equals(pModeReceptionAwareness.m_eReceptionAwareness) && this.m_eRetry.equals(pModeReceptionAwareness.m_eRetry) && this.m_nMaxRetries == pModeReceptionAwareness.m_nMaxRetries && this.m_nRetryIntervalMS == pModeReceptionAwareness.m_nRetryIntervalMS && this.m_eDuplicateDetection.equals(pModeReceptionAwareness.m_eDuplicateDetection);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eReceptionAwareness)).append((Enum)this.m_eRetry)).append(this.m_nMaxRetries).append(this.m_nRetryIntervalMS).append((Enum)this.m_eDuplicateDetection)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ReceptionAwareness", this.m_eReceptionAwareness).append("Retry", this.m_eRetry).append("MaxRetries", this.m_nMaxRetries).append("RetryIntervalMS", this.m_nRetryIntervalMS).append("DuplicateDetection", this.m_eDuplicateDetection).getToString();
    }

    @Nonnull
    public static PModeReceptionAwareness createDefault() {
        return new PModeReceptionAwareness(ETriState.valueOf(true), ETriState.valueOf(true), 1, 10000, ETriState.valueOf(true));
    }
}

